"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApmPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _rxjs = require("rxjs");
var _register_apm_rule_types = require("./components/alerting/rule_types/register_apm_rule_types");
var _register_embeddables = require("./embeddable/register_embeddables");
var _fleet_integration = require("./components/fleet_integration");
var _lazy_apm_agents_tab_extension = require("./components/fleet_integration/lazy_apm_agents_tab_extension");
var _lazy_apm_policy_create_extension = require("./components/fleet_integration/lazy_apm_policy_create_extension");
var _lazy_apm_policy_edit_extension = require("./components/fleet_integration/lazy_apm_policy_edit_extension");
var _feature_catalogue_entry = require("./feature_catalogue_entry");
var _service_detail_locator = require("./locator/service_detail_locator");
var _telemetry = require("./services/telemetry");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const applicationsTitle = _i18n.i18n.translate('xpack.apm.navigation.rootTitle', {
  defaultMessage: 'Applications'
});
const servicesTitle = _i18n.i18n.translate('xpack.apm.navigation.servicesTitle', {
  defaultMessage: 'Service inventory'
});
const serviceGroupsTitle = _i18n.i18n.translate('xpack.apm.navigation.serviceGroupsTitle', {
  defaultMessage: 'Service groups'
});
const tracesTitle = _i18n.i18n.translate('xpack.apm.navigation.tracesTitle', {
  defaultMessage: 'Traces'
});
const serviceMapTitle = _i18n.i18n.translate('xpack.apm.navigation.serviceMapTitle', {
  defaultMessage: 'Service map'
});
const dependenciesTitle = _i18n.i18n.translate('xpack.apm.navigation.dependenciesTitle', {
  defaultMessage: 'Dependencies'
});
const apmSettingsTitle = _i18n.i18n.translate('xpack.apm.navigation.apmSettingsTitle', {
  defaultMessage: 'Settings'
});
const apmStorageExplorerTitle = _i18n.i18n.translate('xpack.apm.navigation.apmStorageExplorerTitle', {
  defaultMessage: 'Storage explorer'
});
const apmTutorialTitle = _i18n.i18n.translate('xpack.apm.navigation.apmTutorialTitle', {
  defaultMessage: 'Tutorial'
});
class ApmPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "isServerlessEnv", void 0);
    this.initializerContext = initializerContext;
    this.initializerContext = initializerContext;
    this.telemetry = new _telemetry.TelemetryService();
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    this.isServerlessEnv = initializerContext.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(core, plugins) {
    var _pluginSetupDeps$home, _pluginSetupDeps$home2, _pluginSetupDeps$home3, _pluginSetupDeps$home4, _pluginSetupDeps$clou, _pluginSetupDeps$clou2;
    const config = this.initializerContext.config.get();
    const pluginSetupDeps = plugins;
    const {
      featureFlags
    } = config;
    if (pluginSetupDeps.home) {
      pluginSetupDeps.home.featureCatalogue.register(_feature_catalogue_entry.featureCatalogueEntry);
    }

    // register observability nav if user has access to plugin
    plugins.observabilityShared.navigation.registerSections((0, _rxjs.from)(core.getStartServices()).pipe((0, _rxjs.map)(([coreStart, pluginsStart]) => {
      if (coreStart.application.capabilities.apm.show) {
        return [
        // APM navigation
        {
          label: applicationsTitle,
          sortKey: 400,
          entries: [{
            label: servicesTitle,
            app: 'apm',
            path: '/services',
            matchPath(currentPath) {
              return ['/service-groups', '/mobile-services', '/services', '/service-map'].some(testPath => currentPath.startsWith(testPath));
            }
          }, {
            label: tracesTitle,
            app: 'apm',
            path: '/traces'
          }, {
            label: dependenciesTitle,
            app: 'apm',
            path: '/dependencies/inventory',
            onClick: () => {
              const {
                usageCollection
              } = pluginsStart;
              if (usageCollection) {
                usageCollection.reportUiCounter('apm', _public2.METRIC_TYPE.CLICK, 'side_nav_dependency');
              }
            }
          }]
        }];
      }
      return [];
    })));
    const getApmDataHelper = async () => {
      const {
        fetchObservabilityOverviewPageData,
        getHasData
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/apm_observability_overview_fetchers')));
      const {
        fetchSpanLinks
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/span_links')));
      const {
        fetchErrorsByTraceId
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/fetch_errors_by_trace_id')));
      const {
        fetchRootSpanByTraceId
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/fetch_trace_root_span_by_trace_id')));
      const {
        fetchSpan
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/fetch_span')));
      const {
        fetchLatencyOverallTransactionDistribution
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/fetch_latency_overall_transaction_distribution')));
      const {
        fetchLatencyOverallSpanDistribution
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/fetch_latency_overall_span_distribution')));
      const {
        hasFleetApmIntegrations
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/tutorial_apm_fleet_check')));
      const {
        createCallApmApi
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/create_call_apm_api')));

      // have to do this here as well in case app isn't mounted yet
      createCallApmApi(core);
      return {
        fetchObservabilityOverviewPageData,
        getHasData,
        hasFleetApmIntegrations,
        fetchSpanLinks,
        fetchErrorsByTraceId,
        fetchRootSpanByTraceId,
        fetchSpan,
        fetchLatencyOverallTransactionDistribution,
        fetchLatencyOverallSpanDistribution
      };
    };
    this.telemetry.setup({
      analytics: core.analytics
    });

    // Registers a status check callback for the tutorial to call and verify if the APM integration is installed on fleet.
    (_pluginSetupDeps$home = pluginSetupDeps.home) === null || _pluginSetupDeps$home === void 0 ? void 0 : _pluginSetupDeps$home.tutorials.registerCustomStatusCheck('apm_fleet_server_status_check', async () => {
      const {
        hasFleetApmIntegrations
      } = await getApmDataHelper();
      return hasFleetApmIntegrations();
    });

    // Registers custom component that is going to be render on fleet section
    (_pluginSetupDeps$home2 = pluginSetupDeps.home) === null || _pluginSetupDeps$home2 === void 0 ? void 0 : _pluginSetupDeps$home2.tutorials.registerCustomComponent('TutorialFleetInstructions', () => Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/tutorial_fleet_instructions'))).then(mod => mod.TutorialFleetInstructions));
    (_pluginSetupDeps$home3 = pluginSetupDeps.home) === null || _pluginSetupDeps$home3 === void 0 ? void 0 : _pluginSetupDeps$home3.tutorials.registerCustomComponent('TutorialConfigAgent', () => Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/config_agent'))).then(mod => mod.TutorialConfigAgent));
    (_pluginSetupDeps$home4 = pluginSetupDeps.home) === null || _pluginSetupDeps$home4 === void 0 ? void 0 : _pluginSetupDeps$home4.tutorials.registerCustomComponent('TutorialConfigAgentRumScript', () => Promise.resolve().then(() => _interopRequireWildcard(require('./tutorial/config_agent/rum_script'))).then(mod => mod.TutorialConfigAgentRumScript));
    pluginSetupDeps.uiActions.registerTrigger({
      id: _common.ObservabilityTriggerId.ApmTransactionContextMenu
    });
    pluginSetupDeps.uiActions.registerTrigger({
      id: _common.ObservabilityTriggerId.ApmErrorContextMenu
    });
    plugins.observability.dashboard.register({
      appName: 'apm',
      hasData: async () => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.getHasData();
      },
      fetchData: async params => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.fetchObservabilityOverviewPageData(params);
      }
    });
    plugins.exploratoryView.register({
      appName: 'apm',
      hasData: async () => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.getHasData();
      },
      fetchData: async params => {
        const dataHelper = await getApmDataHelper();
        return await dataHelper.fetchObservabilityOverviewPageData(params);
      }
    });
    plugins.discoverShared.features.registry.register({
      id: 'observability-traces-fetch-span-links',
      fetchSpanLinks: async (params, signal) => {
        const {
          fetchSpanLinks
        } = await getApmDataHelper();
        return fetchSpanLinks(params, signal);
      }
    });
    plugins.discoverShared.features.registry.register({
      id: 'observability-traces-fetch-errors',
      fetchErrorsByTraceId: async (params, signal) => {
        const {
          fetchErrorsByTraceId
        } = await getApmDataHelper();
        return fetchErrorsByTraceId(params, signal);
      }
    });
    plugins.discoverShared.features.registry.register({
      id: 'observability-traces-fetch-root-span-by-trace-id',
      fetchRootSpanByTraceId: async (params, signal) => {
        const {
          fetchRootSpanByTraceId
        } = await getApmDataHelper();
        return fetchRootSpanByTraceId(params, signal);
      }
    });
    plugins.discoverShared.features.registry.register({
      id: 'observability-traces-fetch-span',
      fetchSpan: async (params, signal) => {
        const {
          fetchSpan
        } = await getApmDataHelper();
        return fetchSpan(params, signal);
      }
    });
    plugins.discoverShared.features.registry.register({
      id: 'observability-traces-fetch-latency-overall-transaction-distribution',
      fetchLatencyOverallTransactionDistribution: async (params, signal) => {
        const {
          fetchLatencyOverallTransactionDistribution
        } = await getApmDataHelper();
        return fetchLatencyOverallTransactionDistribution(params, signal);
      }
    });
    plugins.discoverShared.features.registry.register({
      id: 'observability-traces-fetch-latency-overall-span-distribution',
      fetchLatencyOverallSpanDistribution: async (params, signal) => {
        const {
          fetchLatencyOverallSpanDistribution
        } = await getApmDataHelper();
        return fetchLatencyOverallSpanDistribution(params, signal);
      }
    });
    const {
      observabilityRuleTypeRegistry
    } = plugins.observability;

    // Register APM telemetry based events
    const telemetry = this.telemetry.start();
    const isCloudEnv = !!((_pluginSetupDeps$clou = pluginSetupDeps.cloud) !== null && _pluginSetupDeps$clou !== void 0 && _pluginSetupDeps$clou.isCloudEnabled);
    const isServerlessEnv = ((_pluginSetupDeps$clou2 = pluginSetupDeps.cloud) === null || _pluginSetupDeps$clou2 === void 0 ? void 0 : _pluginSetupDeps$clou2.isServerlessEnabled) || this.isServerlessEnv;
    const kibanaEnvironment = {
      isCloudEnv,
      isServerlessEnv,
      kibanaVersion: this.kibanaVersion
    };
    core.application.register({
      id: 'apm',
      title: 'Applications',
      order: 8300,
      euiIconType: 'logoObservability',
      appRoute: '/app/apm',
      icon: 'plugins/apm/public/icon.svg',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      keywords: ['apm'],
      deepLinks: [{
        id: 'service-groups-list',
        title: serviceGroupsTitle,
        path: '/service-groups'
      }, {
        id: 'services',
        title: servicesTitle,
        path: '/services'
      }, {
        id: 'traces',
        title: tracesTitle,
        path: '/traces'
      }, {
        id: 'service-map',
        title: serviceMapTitle,
        path: '/service-map'
      }, {
        id: 'dependencies',
        title: dependenciesTitle,
        path: '/dependencies/inventory'
      }, {
        id: 'settings',
        title: apmSettingsTitle,
        path: '/settings'
      }, {
        id: 'storage-explorer',
        title: apmStorageExplorerTitle,
        path: '/storage-explorer',
        visibleIn: featureFlags.storageExplorerAvailable ? ['globalSearch'] : []
      }, {
        id: 'tutorial',
        title: apmTutorialTitle,
        path: '/tutorial'
      }],
      mount: async appMountParameters => {
        // Load application bundle and Get start services
        const [{
          renderApp
        }, [coreStart, pluginsStart]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application'))), core.getStartServices()]);
        return renderApp({
          coreStart,
          pluginsSetup: pluginSetupDeps,
          appMountParameters,
          config,
          kibanaEnvironment,
          pluginsStart: pluginsStart,
          observabilityRuleTypeRegistry,
          apmServices: {
            securityService: coreStart.security,
            telemetry
          }
        });
      }
    });
    (0, _register_apm_rule_types.registerApmRuleTypes)(observabilityRuleTypeRegistry);
    (0, _register_embeddables.registerEmbeddables)({
      coreSetup: core,
      pluginsSetup: plugins,
      config,
      kibanaEnvironment,
      observabilityRuleTypeRegistry
    });
    const locator = plugins.share.url.locators.create(new _service_detail_locator.APMServiceDetailLocator(core.uiSettings));
    return {
      locator
    };
  }
  start(core, plugins) {
    var _plugins$observabilit;
    const {
      fleet
    } = plugins;
    (_plugins$observabilit = plugins.observabilityAIAssistant) === null || _plugins$observabilit === void 0 ? void 0 : _plugins$observabilit.service.register(async ({
      registerRenderFunction
    }) => {
      const mod = await Promise.resolve().then(() => _interopRequireWildcard(require('./assistant_functions')));
      mod.registerAssistantFunctions({
        registerRenderFunction
      });
    });
    if (fleet) {
      const agentEnrollmentExtensionData = (0, _fleet_integration.getApmEnrollmentFlyoutData)();
      fleet.registerExtension({
        package: 'apm',
        view: 'agent-enrollment-flyout',
        title: agentEnrollmentExtensionData.title,
        Component: agentEnrollmentExtensionData.Component
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-detail-assets',
        Component: _fleet_integration.LazyApmCustomAssetsExtension
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-policy-create',
        Component: (0, _lazy_apm_policy_create_extension.getLazyAPMPolicyCreateExtension)()
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-policy-edit',
        useLatestPackageVersion: true,
        Component: (0, _lazy_apm_policy_edit_extension.getLazyAPMPolicyEditExtension)()
      });
      fleet.registerExtension({
        package: 'apm',
        view: 'package-policy-edit-tabs',
        tabs: [{
          title: 'APM Agents',
          Component: (0, _lazy_apm_agents_tab_extension.getLazyApmAgentsTabExtension)()
        }]
      });
    }
  }
}
exports.ApmPlugin = ApmPlugin;