"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasFleetApmIntegrations = hasFleetApmIntegrations;
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function hasFleetApmIntegrations() {
  try {
    const {
      hasApmPolicies = false
    } = await (0, _create_call_apm_api.callApmApi)('GET /internal/apm/fleet/has_apm_policies', {
      signal: null
    });
    return hasApmPolicies;
  } catch (e) {
    console.error('Something went wrong while fetching apm fleet data', e);
    return false;
  }
}