"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRollupIntervalForTimeRange = getRollupIntervalForTimeRange;
var _moment = _interopRequireDefault(require("moment"));
var _rollup = require("../../../common/rollup");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the appropriate rollup interval based on the time range.
 * Longer time ranges can tolerate more data delay in exchange for faster queries.
 * - Time range > 3 days: use 60m rollup (data delayed up to 60 min)
 * - Time range > 12 hours: use 10m rollup (data delayed up to 10 min)
 * - Otherwise: use 1m rollup (data delayed up to 1 min)
 */
function getRollupIntervalForTimeRange(startMs, endMs) {
  const duration = _moment.default.duration(endMs - startMs);
  if (duration.asDays() > 3) {
    return _rollup.RollupInterval.SixtyMinutes;
  }
  if (duration.asHours() > 12) {
    return _rollup.RollupInterval.TenMinutes;
  }
  return _rollup.RollupInterval.OneMinute;
}