"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeRangeSchema = void 0;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeRangeSchema = exports.timeRangeSchema = _zod.z.object({
  start: _zod.z.string().describe('The start of the time range, in Elasticsearch date math, like `now-24h`.'),
  end: _zod.z.string().describe('The end of the time range, in Elasticsearch date math, like `now`.')
});