"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFilteredBarSeries = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NUM_SERIES = 5;
const getFilteredBarSeries = barSeries => {
  const sortedSeries = barSeries.sort((a, b) => {
    const aMax = Math.max(...a.data.map(point => point.y));
    const bMax = Math.max(...b.data.map(point => point.y));
    return bMax - aMax;
  });
  return sortedSeries.slice(0, NUM_SERIES);
};
exports.getFilteredBarSeries = getFilteredBarSeries;