"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTransactionLatency = getTransactionLatency;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-shared-plugin/common");
var _document_type = require("../../../../common/document_type");
var _apm = require("../../../../common/es_fields/apm");
var _rollup = require("../../../../common/rollup");
var _latency_aggregation_type = require("../../../lib/helpers/latency_aggregation_type");
var _fetch_timeseries = require("./fetch_timeseries");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getTransactionLatency({
  apmEventClient,
  start,
  end,
  intervalString,
  filter,
  transactionType,
  transactionName,
  latencyAggregationType
}) {
  return (await (0, _fetch_timeseries.fetchSeries)({
    apmEventClient,
    start,
    end,
    operationName: 'assistant_get_transaction_latency',
    unit: 'ms',
    documentType: _document_type.ApmDocumentType.TransactionMetric,
    rollupInterval: _rollup.RollupInterval.OneMinute,
    intervalString,
    filter: filter.concat(...(0, _server.termQuery)(_apm.TRANSACTION_TYPE, transactionType), ...(0, _server.termQuery)(_common.TRANSACTION_NAME, transactionName)),
    groupByFields: [_apm.TRANSACTION_TYPE, _common.TRANSACTION_NAME],
    aggs: {
      ...(0, _latency_aggregation_type.getLatencyAggregation)(latencyAggregationType, _apm.TRANSACTION_DURATION_HISTOGRAM),
      value: {
        bucket_script: {
          buckets_path: {
            latency: 'latency'
          },
          script: 'params.latency / 1000'
        }
      }
    }
  })).map(fetchedSerie => {
    return {
      ...fetchedSerie,
      data: fetchedSerie.data.map(bucket => {
        var _bucket$value;
        return {
          x: bucket.key,
          y: (_bucket$value = bucket.value) === null || _bucket$value === void 0 ? void 0 : _bucket$value.value
        };
      })
    };
  });
}