"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dataViewRouteRepository = void 0;
var _common = require("@kbn/spaces-plugin/common");
var _create_static_data_view = require("./create_static_data_view");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _get_apm_data_view_index_pattern = require("./get_apm_data_view_index_pattern");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const staticDataViewRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/data_view/static',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    var _plugins$spaces, _spacesStart$spacesSe;
    const {
      context,
      plugins,
      request,
      logger
    } = resources;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const coreContext = await context.core;

    // get name of selected (name)space
    const spacesStart = await ((_plugins$spaces = plugins.spaces) === null || _plugins$spaces === void 0 ? void 0 : _plugins$spaces.start());
    const spaceId = (_spacesStart$spacesSe = spacesStart === null || spacesStart === void 0 ? void 0 : spacesStart.spacesService.getSpaceId(request)) !== null && _spacesStart$spacesSe !== void 0 ? _spacesStart$spacesSe : _common.DEFAULT_SPACE_ID;
    if (!spaceId) {
      throw new Error('No spaceId found');
    }
    const dataViewStart = await plugins.dataViews.start();
    const dataViewService = await dataViewStart.dataViewsServiceFactory(coreContext.savedObjects.client, coreContext.elasticsearch.client.asCurrentUser, request, true);
    const res = await (0, _create_static_data_view.createOrUpdateStaticDataView)({
      dataViewService,
      resources,
      apmEventClient,
      spaceId,
      logger
    });
    return res;
  }
});
const dataViewTitleRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'GET /internal/apm/data_view/index_pattern',
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async ({
    getApmIndices
  }) => {
    const apmIndices = await getApmIndices();
    const apmDataViewIndexPattern = (0, _get_apm_data_view_index_pattern.getApmDataViewIndexPattern)(apmIndices);
    return {
      apmDataViewIndexPattern,
      apmIndices
    };
  }
});
const dataViewRouteRepository = exports.dataViewRouteRepository = {
  ...staticDataViewRoute,
  ...dataViewTitleRoute
};