"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreams = getDataStreams;
var _get_indices = require("./get_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreams({
  esClient,
  apmIndices
}) {
  const apmIndexPatterns = (0, _get_indices.getApmIndexPatterns)([apmIndices.error, apmIndices.metric, apmIndices.span, apmIndices.transaction]);

  // fetch APM data streams
  const {
    data_streams: dataStreams
  } = await esClient.indices.getDataStream({
    name: apmIndexPatterns,
    filter_path: ['data_streams.name', 'data_streams.template'],
    // @ts-expect-error
    ignore_unavailable: true
  });
  return dataStreams !== null && dataStreams !== void 0 ? dataStreams : [];
}