"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldCaps = getFieldCaps;
var _apm = require("../../../../common/es_fields/apm");
var _get_indices = require("./get_indices");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getFieldCaps({
  esClient,
  apmIndices
}) {
  return esClient.fieldCaps({
    index: (0, _get_indices.getApmIndexPatterns)([apmIndices.metric, apmIndices.transaction]),
    fields: [_apm.SERVICE_NAME],
    filter_path: ['fields'],
    filters: '-parent',
    include_unmapped: true,
    ignore_unavailable: true
  });
}