"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.markError = markError;
var _server = require("@kbn/apm-sources-access-plugin/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function markError({
  id,
  body,
  error,
  internalESClient
}) {
  const params = {
    index: _server.APM_AGENT_CONFIGURATION_INDEX,
    id,
    // by specifying the `id` elasticsearch will do an "upsert"
    body: {
      ...body,
      applied_by_agent: false,
      error
    }
  };
  return internalESClient.index('mark_configuration_error', params);
}