"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spanLatencyDistributionRouteRepository = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _server = require("@kbn/observability-plugin/server");
var _get_overall_latency_distribution = require("../latency_distribution/get_overall_latency_distribution");
var _create_apm_server_route = require("../apm_routes/create_apm_server_route");
var _default_api_types = require("../default_api_types");
var _apm = require("../../../common/es_fields/apm");
var _latency_distribution_chart_types = require("../../../common/latency_distribution_chart_types");
var _get_apm_event_client = require("../../lib/helpers/get_apm_event_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const latencyOverallSpanDistributionRoute = (0, _create_apm_server_route.createApmServerRoute)({
  endpoint: 'POST /internal/apm/latency/overall_distribution/spans',
  params: t.type({
    body: t.intersection([t.partial({
      serviceName: t.string,
      spanName: t.string,
      transactionId: t.string,
      termFilters: t.array(t.type({
        fieldName: t.string,
        fieldValue: t.union([t.string, _ioTsUtils.toNumberRt])
      })),
      durationMin: _ioTsUtils.toNumberRt,
      durationMax: _ioTsUtils.toNumberRt,
      isOtel: t.boolean
    }), _default_api_types.environmentRt, _default_api_types.kueryRt, _default_api_types.rangeRt, t.type({
      percentileThreshold: _ioTsUtils.toNumberRt,
      chartType: _latency_distribution_chart_types.latencyDistributionChartTypeRt
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['apm']
    }
  },
  handler: async resources => {
    var _termFilters$flatMap;
    const apmEventClient = await (0, _get_apm_event_client.getApmEventClient)(resources);
    const {
      environment,
      kuery,
      serviceName,
      spanName,
      start,
      end,
      percentileThreshold,
      durationMin,
      durationMax,
      termFilters,
      chartType,
      isOtel = false
    } = resources.params.body;
    return (0, _get_overall_latency_distribution.getOverallLatencyDistribution)({
      apmEventClient,
      chartType,
      environment,
      kuery,
      start,
      end,
      query: {
        bool: {
          filter: [...(0, _server.termQuery)(_apm.SERVICE_NAME, serviceName), ...(0, _server.termQuery)(_apm.SPAN_NAME, spanName), ...((_termFilters$flatMap = termFilters === null || termFilters === void 0 ? void 0 : termFilters.flatMap(fieldValuePair => (0, _server.termQuery)(fieldValuePair.fieldName, fieldValuePair.fieldValue))) !== null && _termFilters$flatMap !== void 0 ? _termFilters$flatMap : [])]
        }
      },
      percentileThreshold,
      durationMinOverride: durationMin,
      durationMaxOverride: durationMax,
      searchMetrics: false,
      isOtel
    });
  }
});
const spanLatencyDistributionRouteRepository = exports.spanLatencyDistributionRouteRepository = latencyOverallSpanDistributionRoute;