"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnifiedTraceSpan = getUnifiedTraceSpan;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-plugin/common");
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _apm = require("../../../common/es_fields/apm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getUnifiedTraceSpan({
  spanId,
  traceId,
  apmEventClient,
  start,
  end,
  fields = ['*']
}) {
  const params = {
    apm: {
      events: [_common.ProcessorEvent.span, _common.ProcessorEvent.transaction]
    },
    track_total_hits: false,
    size: 1,
    terminate_after: 1,
    fields,
    query: {
      bool: {
        filter: [...(0, _server.termQuery)(_apm.SPAN_ID, spanId), ...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.rangeQuery)(start, end)],
        ...(spanId ? {} : {
          must_not: (0, _server.existsQuery)(_apm.PARENT_ID)
        }),
        should: [...(0, _server.termsQuery)(_apm.PROCESSOR_EVENT, _common.ProcessorEvent.span, _common.ProcessorEvent.transaction), {
          bool: {
            must_not: (0, _server.existsQuery)(_apm.PROCESSOR_EVENT)
          }
        }],
        minimum_should_match: 1
      }
    }
  };
  const resp = await apmEventClient.search('get_unified_trace_span', params, {
    skipProcessorEventFilter: true
  });
  const hit = resp.hits.hits[0];
  if (!hit) {
    return undefined;
  }
  const _id = hit === null || hit === void 0 ? void 0 : hit._id;
  const _index = hit === null || hit === void 0 ? void 0 : hit._index;
  const event = (0, _utils.accessKnownApmEventFields)(hit.fields).unflatten();
  if (!event) {
    return undefined;
  }
  return {
    ...event,
    _id,
    _index
  };
}