/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.apm_bundle_jsonpfunction=self.apm_bundle_jsonpfunction||[]).push([[1092],{21092:(e,a,n)=>{n.r(a),n.d(a,{Onboarding:()=>ke});var t=n(84286),i=n.n(t),r=n(20409),s=n(81319),l=n(12965),o=n(57991),u=n(75008),c=n(75879),p=n(52475),d=n(96791);function g({isBeta:e,guideLink:a}){const n=(0,d.jsx)(s.EuiBetaBadge,{label:u.i18n.translate("xpack.apm.onboarding.betaLabel",{defaultMessage:"Beta"})}),t=(0,p.D)("/plugins/apm/assets/apm.png"),r=[(0,d.jsx)(s.EuiImage,{size:"l",allowFullScreen:!0,fullScreenIconColor:"dark",alt:u.i18n.translate("xpack.apm.onboarding.introduction.imageAltDescription",{defaultMessage:"screenshot of primary dashboard."}),url:t})];return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiPageHeader,{iconType:"apmApp",pageTitle:(0,d.jsx)(i().Fragment,null,u.i18n.translate("xpack.apm.onboarding.appName",{defaultMessage:"APM"}),e&&(0,d.jsx)(i().Fragment,null," ",n)),description:(0,d.jsx)(s.EuiText,null,(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.specProvider.longDescription",defaultMessage:"Application Performance Monitoring (APM) collects in-depth performance metrics and errors from inside your application. It allows you to monitor the performance of thousands of applications in real time. {learnMoreLink}.",values:{learnMoreLink:(0,d.jsx)(s.EuiLink,{"data-test-subj":"apmIntroductionLearnMoreLink",href:a,"aria-label":u.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreAriaLabel",{defaultMessage:"Learn more about APM"}),target:"_blank"},u.i18n.translate("xpack.apm.onboarding.specProvider.learnMoreLabel",{defaultMessage:"Learn more"}))}})),rightSideItems:r}))}var m=n(1493),k=n(38498),y=n(88450),f=n(70200);function v({agentTabs:e,selectedTab:a}){const n=(0,m.useHistory)(),{euiTheme:t}=(0,s.useEuiTheme)();return(0,d.jsx)(s.EuiTabs,{css:(0,d.css)("padding:0 ",t.size.l,";","")},e.map((e=>(0,d.jsx)(s.EuiTab,{key:e.id,isSelected:e.id===a,onClick:()=>{return a=e.id,void(0,f.VC)(n,{query:{agent:a}});var a}},e.text))))}function x({instructions:e,selectedTab:a}){const n=e.find((e=>e.id===a));return n?(0,d.jsx)(i().Fragment,null,n.title&&(0,d.jsx)(s.EuiTitle,{size:"m"},(0,d.jsx)("h2",null,n.title)),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiSteps,{titleSize:"xs",steps:n.instructions})):(0,d.jsx)(i().Fragment,null)}function h({instructions:e}){const a=(0,t.useMemo)((()=>e.map((e=>({id:e.id,text:(0,k.K)(e.id)})))),[e]),{query:{agent:n}}=(0,y.Oh)("/onboarding"),i=null!=n?n:a[0].id;return(0,d.jsx)(s.EuiSplitPanel.Outer,null,(0,d.jsx)(s.EuiSplitPanel.Inner,{color:"subdued",paddingSize:"none"},(0,d.jsx)(v,{agentTabs:a,selectedTab:i})),(0,d.jsx)(s.EuiSplitPanel.Inner,{paddingSize:"l"},(0,d.jsx)(x,{instructions:e,selectedTab:i})))}var A=n(55907);const S=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceNameHint",{defaultMessage:"The service name is the primary filter in the APM UI and is used to group errors and trace data together. Allowed characters are a-z, A-Z, 0-9, -, _, and space."}),E=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.secretTokenHint",{defaultMessage:"Use if APM Server requires a secret token. Both the agent and APM Server must be configured with the same token. This ensures that only your agents can send data to your APM server."}),b=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.apiKeyHint",{defaultMessage:"Use if APM Server requires an API Key. This is used to ensure that only your agents can send data to your APM server. Agents can use API keys as a replacement of secret token, APM server can have multiple API keys. When both secret token and API key are used, API key has priority and secret token is ignored."}),M=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serverUrlHint",{defaultMessage:"Set the custom APM Server URL (default: {defaultApmServerUrl}). The URL must be fully qualified, including protocol (http or https) and port.",values:{defaultApmServerUrl:"http://localhost:8200"}}),j=u.i18n.translate("xpack.apm.onboarding.shared_clients.configure.commands.serviceEnvironmentHint",{defaultMessage:'The name of the environment this service is deployed in, e.g., "production" or "staging". Environments allow you to easily filter data on a global level in the APM UI. It\'s important to be consistent when naming environments across agents.'}),K=e=>({...e&&{secretToken:"elastic.apm.secret_token"},...!e&&{apiKey:"elastic.apm.api_key"},apmServerUrl:"elastic.apm.server_url"}),C=e=>({start:1,highlight:"",annotations:{2:S,3:e?b:E,4:M,5:j}}),T=e=>({...e&&{secretToken:"secretToken"},...!e&&{apiKey:"apiKey"},apmServerUrl:"serverUrl"}),P=`// ${u.i18n.translate("xpack.apm.onboarding.nodeClient.configure.commands.addThisToTheFileTopComment",{defaultMessage:"Add this to the very top of the first file loaded in your app"})}\nvar apm = require('elastic-apm-node').start({\n  // {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.nodeClient.createConfig.commands.serviceName",{defaultMessage:"Overrides the service name in package.json."})}\n  serviceName: '<your-service-name>',\n\n  {{^secretToken}}\n  // {{apiKeyHint}}\n  apiKey: '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  // {{secretTokenHint}}\n  secretToken: '{{{secretToken}}}',\n  {{/secretToken}}\n\n  // {{{serverUrlHint}}}\n  serverUrl: '{{{apmServerUrl}}}',\n\n  // {{{serviceEnvironmentHint}}}\n  environment: '<your-environment>'\n})`,L=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),w=`INSTALLED_APPS = (\n  # ${u.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addAgentComment",{defaultMessage:"Add the agent to installed apps"})}\n  'elasticapm.contrib.django',\n  # ...\n)\n\nELASTIC_APM = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\nMIDDLEWARE = (\n  # ${u.i18n.translate("xpack.apm.onboarding.djangoClient.configure.commands.addTracingMiddlewareComment",{defaultMessage:"Add our tracing middleware to send performance metrics"})}\n  'elasticapm.contrib.django.middleware.TracingMiddleware',\n  #...\n)`,_=e=>({...e&&{secretToken:"SECRET_TOKEN"},...!e&&{apiKey:"API_KEY"},apmServerUrl:"SERVER_URL"}),I=`# ${u.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp = Flask(__name__)\napm = ElasticAPM(app)\n\n# ${u.i18n.translate("xpack.apm.onboarding.flaskClient.configure.commands.configureElasticApmComment",{defaultMessage:"Or use ELASTIC_APM in your application's settings"})}\nfrom elasticapm.contrib.flask import ElasticAPM\napp.config['ELASTIC_APM'] = {\n  # {{serviceNameHint}}\n  'SERVICE_NAME': '<your-service-name>',\n  {{^secretToken}}\n  # {{apiKeyHint}}\n  'API_KEY': '{{{apiKey}}}',\n  {{/secretToken}}\n  {{#secretToken}}\n  # {{secretTokenHint}}\n  'SECRET_TOKEN': '{{{secretToken}}}',\n  {{/secretToken}}\n\n  # {{{serverUrlHint}}}\n  'SERVER_URL': '{{{apmServerUrl}}}',\n\n  # {{{serviceEnvironmentHint}}}\n  'ENVIRONMENT': '<your-environment>',\n}\n\napm = ElasticAPM(app)`,F=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),U=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.railsClient.createConfig.commands.defaultServiceName",{defaultMessage:"Defaults to the name of your Rails app."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,N=e=>({...e&&{secretToken:"secret_token"},...!e&&{apiKey:"api_key"},apmServerUrl:"server_url"}),H=`# config/elastic_apm.yml:\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.rackClient.createConfig.commands.defaultsToTheNameOfRackAppClassComment",{defaultMessage:"Defaults to the name of your Rack app's class."})}\nservice_name: '<your-service-name>'\n\n{{^secretToken}}\n# {{apiKeyHint}}\napi_key: '{{{apiKey}}}'\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nsecret_token: '{{{secretToken}}}'\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nserver_url: '{{{apmServerUrl}}}'\n\n# {{{serviceEnvironmentHint}}}\nenvironment: '<your-environment>'`,R=e=>({...e&&{secretToken:"ELASTIC_APM_SECRET_TOKEN"},...!e&&{apiKey:"ELASTIC_APM_API_KEY"},apmServerUrl:"ELASTIC_APM_SERVER_URL"}),D=`# ${u.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.initializeUsingEnvironmentVariablesComment",{defaultMessage:"Initialize using environment variables:"})}\n\n# {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.goClient.configure.commands.usedExecutableNameComment",{defaultMessage:"If not specified, the executable name will be used."})}\nexport ELASTIC_APM_SERVICE_NAME=<your-service-name>\n\n{{^secretToken}}\n# {{apiKeyHint}}\nexport ELASTIC_APM_API_KEY={{{apiKey}}}\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nexport ELASTIC_APM_SECRET_TOKEN={{{secretToken}}}\n{{/secretToken}}\n\n# {{{serverUrlHint}}}\nexport ELASTIC_APM_SERVER_URL={{{apmServerUrl}}}\n\n# {{{serviceEnvironmentHint}}}\nexport ELASTIC_APM_ENVIRONMENT=<your-environment>\n`,O=e=>({...e&&{secretToken:"SecretToken"},...!e&&{apiKey:"ApiKey"},apmServerUrl:"ServerUrl"}),B=`{\n  "ElasticApm": {\n    /// {{serviceNameHint}} ${u.i18n.translate("xpack.apm.onboarding.dotnetClient.createConfig.commands.defaultServiceName",{defaultMessage:"Default is the entry assembly of the application."})}\n    "ServiceName": "<your-service-name>",\n    {{^secretToken}}\n    /// {{apiKeyHint}}\n    "ApiKey": "{{{apiKey}}}",\n    {{/secretToken}}\n    {{#secretToken}}\n    /// {{secretTokenHint}}\n    "SecretToken": "{{{secretToken}}}",\n    {{/secretToken}}\n    /// {{{serverUrlHint}}}\n    "ServerUrl": "{{{apmServerUrl}}}",\n    /// {{{serviceEnvironmentHint}}}\n    "Environment": "<your-environment>",\n  }\n}`,$=e=>({...e&&{secretToken:"elastic_apm.secret_token"},...!e&&{apiKey:"elastic_apm.api_key"},apmServerUrl:"elastic_apm.server_url"}),V={java:"java -javaagent:/path/to/elastic-apm-agent-<version>.jar \\\n-Delastic.apm.service_name=<your-service-name> \\\n{{^secretToken}}\n-Delastic.apm.api_key={{{apiKey}}} \\\n{{/secretToken}}\n{{#secretToken}}\n-Delastic.apm.secret_token={{{secretToken}}} \\\n{{/secretToken}}\n-Delastic.apm.server_url={{{apmServerUrl}}} \\\n-Delastic.apm.environment=<your-environment> \\\n-Delastic.apm.application_packages=org.example \\\n-jar my-service-name.jar",node:P,django:w,flask:I,rails:U,rack:H,go:D,dotnet:B,php:'# {{serviceNameHint}}\nelastic_apm.service_name="<your-service-name>"\n\n{{^secretToken}}\n# {{apiKeyHint}}\nelastic_apm.api_key="{{{apiKey}}}"\n{{/secretToken}}\n{{#secretToken}}\n# {{secretTokenHint}}\nelastic_apm.secret_token="{{{secretToken}}}"\n{{/secretToken}}\n\n# {{serverUrlHint}}\nelastic_apm.server_url="{{{apmServerUrl}}}"\n\n# {{{serviceEnvironmentHint}}}\nelastic_apm.environment="<your-environment>"'},G={java:"java",node:"js",django:"py",flask:"py",rails:"rb",rack:"rb",go:"go",dotnet:"dotnet",php:"php"};function X({variantId:e,apmServerUrl:a,secretToken:n,apiKey:t}){const i=V[e];return i?A.A.render(i,{apmServerUrl:a,secretToken:n,apiKey:t,serviceNameHint:S,serviceEnvironmentHint:j,serverUrlHint:M,secretTokenHint:E,apiKeyHint:b}):""}var z=n(30770),q=n(25083);function W({columnKey:e,value:a,createApiKey:n,createApiKeyLoading:t}){return"apiKey"===e&&null===a?(0,d.jsx)(s.EuiButton,{"data-test-subj":"createApiKeyAndId",fill:!0,onClick:n,isLoading:t},u.i18n.translate("xpack.apm.tutorial.apiKey.create",{defaultMessage:"Create API Key"})):(0,d.jsx)(i().Fragment,null,(q.yH.includes(e)||"apiKey"===e)&&a?(0,d.jsx)(s.EuiFieldPassword,{type:"dual",value:null!=a?a:"","data-test-subj":"secret_key"}):(0,d.jsx)(s.EuiText,{size:"s",color:"accent"},a),a&&(0,d.jsx)(s.EuiButtonIcon,{"data-test-subj":"apmConfigurationValueColumnButton","aria-label":u.i18n.translate("xpack.apm.onboarding.column.value.copyIconText",{defaultMessage:"Copy to clipboard"}),color:"text",iconType:"copy",onClick:()=>(0,s.copyToClipboard)(a)}))}function Y({variables:e,data:a,createApiKey:n,createApiKeyLoading:t}){if(!e)return null;const i={apmServiceName:"my-service-name",apmEnvironment:"my-environment"},r=[{field:"setting",name:u.i18n.translate("xpack.apm.onboarding.agent.column.configSettings",{defaultMessage:"Configuration setting"})},{field:"value",name:u.i18n.translate("xpack.apm.onboarding.agent.column.configValue",{defaultMessage:"Configuration value"}),render:(e,{value:a,key:i})=>(0,d.jsx)(W,{columnKey:i,value:a,createApiKey:n,createApiKeyLoading:t})}],l=Object.entries(e).map((([e,n])=>({setting:n,value:(0,z.get)({...a,...i},e),key:e})));return(0,d.jsx)(s.EuiBasicTable,{items:l,columns:r})}var J=n(47787);function Z({variantId:e,apmServerUrl:a,secretToken:n,apiKey:t,createApiKey:r,createApiKeyLoading:l}){const o=X({variantId:e,apmServerUrl:a,secretToken:"<SECRET_TOKEN>",apiKey:" <API_KEY>"}),u=X({variantId:e,apmServerUrl:a,secretToken:n,apiKey:t}),c=function(e,a){return(e=>({java:K(e),node:T(e),django:L(e),flask:_(e),rails:F(e),rack:N(e),go:R(e),dotnet:O(e),php:$(e)}))(a)[e]}(e,n),p=function(e,a){return(e=>({java:C(e),node:{start:1,highlight:"2, 4, 7, 10, 13-14"},django:{start:1,highlight:"1, 3, 5, 7, 9, 12, 15, 18-19, 21, 23, 25"},flask:{start:1,highlight:"2-4, 7-8, 10, 12, 15, 18-21"},rails:{start:1,highlight:"4, 7, 10, 13"},rack:{start:1,highlight:"4, 7, 10, 13"},go:{start:1,highlight:"4, 7, 10, 13"},dotnet:{start:1,highlight:"1-2, 4, 6, 8, 10-12"},php:{start:1,highlight:"2, 5, 8, 11"}}))(a)[e]}(e,t),g=function(e){return G[e]}(e);return(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(Y,{variables:c,data:{apmServerUrl:a,secretToken:n,apiKey:t},createApiKey:r,createApiKeyLoading:l}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(J.I,{variantId:e,lineNumbers:p,highlightLang:g,commands:o,commandsWithSecrets:u}))}function Q({isSuccess:e,isError:a,errorMessage:n}){return e?(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutTitle",{defaultMessage:"API key created"}),color:"success",iconType:"check","data-test-subj":"apiKeySuccessCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.success.calloutMessage",{defaultMessage:"Remember to store this information in a safe place. It won't be displayed anymore after you continue"}))):a&&/missing the following requested privilege\(s\)/.test(n||"")?(0,d.jsx)(s.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutTitle",{defaultMessage:"User does not have permissions to create API Key"}),color:"warning",iconType:"warning","data-test-subj":"apiKeyWarningCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.warning.calloutMessage",{defaultMessage:"User is missing the following privilege - {missingPrivilege}. Please add the missing APM application privilege to the role of the authenticated user",values:{missingPrivilege:"event:write"}})):(0,d.jsx)(s.EuiCallOut,{title:u.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutTitle",{defaultMessage:"Failed to create API key"}),color:"danger",iconType:"error","data-test-subj":"apiKeyErrorCallout"},u.i18n.translate("xpack.apm.onboarding.apiKey.error.calloutMessage",{defaultMessage:"Error: {errorMessage}",values:{errorMessage:n}}))}function ee(){return(0,d.jsx)(s.EuiCallOut,{color:"warning","data-test-subj":"agentStatusWarningCallout"},u.i18n.translate("xpack.apm.onboarding.agentStatus.warning.calloutMessage",{defaultMessage:"No data has been received from agents yet"}))}function ae(){return(0,d.jsx)(s.EuiCallOut,{color:"success","data-test-subj":"agentStatusSuccessCallout"},u.i18n.translate("xpack.apm.onboarding.agentStatus.success.calloutMessage",{defaultMessage:"Data successfully received from one or more agents"}))}function ne({checkAgentStatus:e,agentStatus:a,agentStatusLoading:n}){let t="incomplete",r=(0,d.jsx)(i().Fragment,null);return!1===a&&(t="warning",r=(0,d.jsx)(ee,null)),a&&(t="complete",r=(0,d.jsx)(ae,null)),{title:u.i18n.translate("xpack.apm.onboarding.agentStatusCheck.title",{defaultMessage:"Explore your data"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.agentStatusCheck.textPre",{defaultMessage:"Make sure your application is running and data is flowing into Elastic Observability."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiButton,{"data-test-subj":"checkAgentStatus",onClick:e,isLoading:n},u.i18n.translate("xpack.apm.onboarding.agentStatus.check",{defaultMessage:"Check status"})),(0,d.jsx)(s.EuiSpacer,null),r),status:t}}const te=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.java.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.download.textPre",{defaultMessage:"Download the agent jar from [Maven Central]({mavenCentralLink}).       Do **not** add the agent as a dependency to your application.",values:{mavenCentralLink:"https://oss.sonatype.org/service/local/artifact/maven/redirect?r=releases&g=co.elastic.apm&a=elastic-apm-agent&v=LATEST"}}))},{title:u.i18n.translate("xpack.apm.onboarding.java.startApplication.title",{defaultMessage:"Start your application with the javaagent flag"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.startApplication.textPre",{defaultMessage:"Add the `-javaagent` flag and configure the agent with system properties.\n\n * Set the required service name (allowed characters: a-z, A-Z, 0-9, -, _, and space)\n * Set the custom APM Server URL (default: {customApmServerUrl})\n * Set the APM Server secret token\n * Set the service environment\n * Set the base package of your application",values:{customApmServerUrl:"http://localhost:8200"}})),(0,d.jsx)(s.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.JAVA,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.java.startApplication.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced         usage.",values:{documentationLink:`${a}guide/en/apm/agent/java/current/index.html`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},ie=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.node.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.install.textPre",{defaultMessage:"Install the APM agent for Node.js as a dependency to your application."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.node.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Node.js"})},"npm install elastic-apm-node --save"))},{title:u.i18n.translate("xpack.apm.onboarding.node.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process.  APM services are created programmatically based on the `serviceName`.  This agent supports a variety of frameworks but can also be used with your custom stack."})),(0,d.jsx)(s.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.NODE,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.node.configure.textPost",{defaultMessage:"See [the documentation]({documentationLink}) for advanced usage, including how to use with [Babel/ES Modules]({babelEsModulesLink}).",values:{documentationLink:`${a}guide/en/apm/agent/nodejs/current/index.html`,babelEsModulesLink:`${a}guide/en/apm/agent/nodejs/current/advanced-setup.html#es-modules`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},re=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.django.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.django.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Django"})},"$ pip install elastic-apm"))},{title:u.i18n.translate("xpack.apm.onboarding.django.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),(0,d.jsx)(s.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.DJANGO,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.django.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/django-support.html`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},se=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.flask.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.install.textPre",{defaultMessage:"Install the APM agent for Python as a dependency."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.flask.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Flask"})},"$ pip install elastic-apm[flask]"))},{title:u.i18n.translate("xpack.apm.onboarding.flask.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the `SERVICE_NAME`."})),(0,d.jsx)(s.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.FLASK,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.flask.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced usage.",values:{documentationLink:`${a}guide/en/apm/agent/python/current/flask-support.html`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},le=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.rails.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rails.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Ruby on Rails"})},"gem 'elastic-apm'"))},{title:u.i18n.translate("xpack.apm.onboarding.rails.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.configure.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent, by creating the config file {configFile}",values:{configFile:"`config/elastic_apm.yml`"}})),(0,d.jsx)(s.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.RAILS,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rails.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},oe=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e,c=`# config.ru\n  require 'sinatra/base'\n\n  class MySinatraApp < Sinatra::Base\n    use ElasticAPM::Middleware\n\n    # ...\n  end\n\n  ElasticAPM.start(\n    app: MySinatraApp, # ${u.i18n.translate("xpack.apm.onboarding.rack.configure.commands.requiredComment",{defaultMessage:"required"})}\n    config_file: '' # ${u.i18n.translate("xpack.apm.onboarding.rack.configure.commands.optionalComment",{defaultMessage:"optional, defaults to config/elastic_apm.yml"})}\n  )\n\n  run MySinatraApp\n\n  at_exit { ElasticAPM.stop }`;return[{title:u.i18n.translate("xpack.apm.onboarding.rack.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.install.textPre",{defaultMessage:"Add the agent to your Gemfile."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rack.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Rack"})},"gem 'elastic-apm'"))},{title:u.i18n.translate("xpack.apm.onboarding.rack.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.configure.textPre",{defaultMessage:"For Rack or a compatible framework (e.g. Sinatra), include the middleware in your app and start the agent."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.rack.configure.copyAriaLabel",{defaultMessage:"Copy the code to configure the APM agent for Rack"})},c))},{title:u.i18n.translate("xpack.apm.onboarding.rack.createConfig.title",{defaultMessage:"Create config file"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.createConfig.textPre",{defaultMessage:"Create a config file {configFile}:",values:{configFile:"`config/elastic_apm.yml`"}})),(0,d.jsx)(s.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.RACK,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.rack.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/ruby/current/index.html`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},ue=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.go.install.title",{defaultMessage:"Install the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.install.textPre",{defaultMessage:"Install the APM agent packages for Go."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.go.install.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for Go"})},"go get go.elastic.co/apm"))},{title:u.i18n.translate("xpack.apm.onboarding.go.configure.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.configure.textPre",{defaultMessage:"Agents are libraries that run inside of your application process. APM services are created programmatically based on the executable file name, or the `ELASTIC_APM_SERVICE_NAME` environment variable."})),(0,d.jsx)(s.EuiSpacer,null),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.GO,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.configure.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for advanced configuration.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/configuration.html`}})))},{title:u.i18n.translate("xpack.apm.onboarding.go.goClient.title",{defaultMessage:"Instrument your application"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.instrument.textPre",{defaultMessage:"Instrument your Go application by using one of the provided instrumentation modules or by using the tracer API directly."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"go",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.go.instrument.copyAriaLabel",{defaultMessage:"Copy the code to instrument your Go application"})},'import (\n  "net/http"\n\n  "go.elastic.co/apm/module/apmhttp"\n)\n\nfunc main() {\n  mux := http.NewServeMux()\n  ...\n  http.ListenAndServe(":8080", apmhttp.Wrap(mux))\n}\n'),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.go.instrument.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for a detailed guide to instrumenting Go source code.",values:{documentationLink:`${a}guide/en/apm/agent/go/current/instrumenting-source.html`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},ce=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.dotNet.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.download.textPre",{defaultMessage:"Add the the agent package(s) from [NuGet]({allNuGetPackagesLink}) to your .NET application. There are multiple       NuGet packages available for different use cases. \n\nFor an ASP.NET Core application with Entity Framework       Core download the [Elastic.Apm.NetCoreAll]({netCoreAllApmPackageLink}) package. This package will automatically add every       agent component to your application. \n\n In case you would like to minimize the dependencies, you can use the       [Elastic.Apm.AspNetCore]({aspNetCorePackageLink}) package for just       ASP.NET Core monitoring or the [Elastic.Apm.EfCore]({efCorePackageLink}) package for just Entity Framework Core monitoring. \n\n In       case you only want to use the public Agent API for manual instrumentation use the [Elastic.Apm]({elasticApmPackageLink}) package.",values:{allNuGetPackagesLink:"https://www.nuget.org/packages?q=Elastic.apm",netCoreAllApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm.NetCoreAll",aspNetCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.AspNetCore",efCorePackageLink:"https://www.nuget.org/packages/Elastic.Apm.EntityFrameworkCore",elasticApmPackageLink:"https://www.nuget.org/packages/Elastic.Apm"}})))},{title:u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.title",{defaultMessage:"Add the agent to the application"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPre",{defaultMessage:"In case of ASP.NET Core with the `Elastic.Apm.NetCoreAll` package, call the `AddAllElasticApm`       extension method on the `IServiceCollection` within the `Program.cs` file."})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.copyAriaLabel",{defaultMessage:"Copy the code to add the APM agent to the dotnet application"})},"var builder = WebApplication.CreateBuilder(args);\n\nbuilder.Services.AddAllElasticApm();\n\nvar app = builder.Build();\n\n// Configure the HTTP request pipeline.\n\napp.Run();"),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureApplication.textPost",{defaultMessage:"The agent will implicitly read config settings through the application’s       `IConfiguration` instance (e.g. from the `appsettings.json` file)."})))},{title:u.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.title",{defaultMessage:"Sample appsettings.json file:"}),children:(0,d.jsx)(i().Fragment,null,((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.DOTNET,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.dotNet.configureAgent.textPost",{defaultMessage:"You can also configure the agent through environment variables. \n       See [the documentation]({documentationLink}) for advanced usage, including the [Profiler Auto instrumentation]({profilerLink}) quick start.",values:{documentationLink:`${a}guide/en/apm/agent/dotnet/current/configuration.html`,profilerLink:`${a}guide/en/apm/agent/dotnet/current/setup-auto-instrumentation.html#setup-auto-instrumentation`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},pe=e=>{const{baseUrl:a,apmServerUrl:n,apiKeyDetails:t,checkAgentStatus:r,agentStatus:l,agentStatusLoading:o}=e;return[{title:u.i18n.translate("xpack.apm.onboarding.php.download.title",{defaultMessage:"Download the APM agent"}),children:(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.download.textPre",{defaultMessage:"Download the package corresponding to your platform from [GitHub releases]({githubReleasesLink}).",values:{githubReleasesLink:"https://github.com/elastic/apm-agent-php/releases"}}))},{title:u.i18n.translate("xpack.apm.onboarding.php.installPackage.title",{defaultMessage:"Install the downloaded package"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.installPackage.textPre",{defaultMessage:"For example on Alpine Linux using APK package:"})),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiCodeBlock,{language:"bash",isCopyable:!0,copyAriaLabel:u.i18n.translate("xpack.apm.onboarding.php.installPackage.copyAriaLabel",{defaultMessage:"Copy the code to install the APM agent for PHP"})},"apk add --allow-untrusted <package-file>.apk"),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.installPackage.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for installation commands on other supported platforms and advanced installation.",values:{documentationLink:`${a}guide/en/apm/agent/php/current/setup.html`}})))},{title:u.i18n.translate("xpack.apm.onboarding.php.configureAgent.title",{defaultMessage:"Configure the agent"}),children:(0,d.jsx)(i().Fragment,null,(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.Configure the agent.textPre",{defaultMessage:"APM is automatically started when your app boots. Configure the agent either via `php.ini` file:"})),((null==t?void 0:t.displayApiKeySuccessCallout)||(null==t?void 0:t.displayApiKeyErrorCallout))&&(0,d.jsx)(i().Fragment,null,(0,d.jsx)(Q,{isError:null==t?void 0:t.displayApiKeyErrorCallout,isSuccess:null==t?void 0:t.displayApiKeySuccessCallout,errorMessage:null==t?void 0:t.errorMessage}),(0,d.jsx)(s.EuiSpacer,null)),(0,d.jsx)(Z,{variantId:k.X.PHP,apmServerUrl:n,apiKey:null==t?void 0:t.apiKey,createApiKey:null==t?void 0:t.createAgentKey,createApiKeyLoading:null==t?void 0:t.createApiKeyLoading}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(s.EuiMarkdownFormat,null,u.i18n.translate("xpack.apm.onboarding.php.configureAgent.textPost",{defaultMessage:"See the [documentation]({documentationLink}) for configuration options and advanced usage.\n\n",values:{documentationLink:`${a}guide/en/apm/agent/php/current/configuration.html`}})))},ne({checkAgentStatus:r,agentStatus:l,agentStatusLoading:o})]},de=u.i18n.translate("xpack.apm.onboarding.defaultTitle",{defaultMessage:"APM Agents"});function ge(){const e=(0,p.D)("/app/apm");return(0,d.jsx)(s.EuiPanel,{paddingSize:"l"},(0,d.jsx)(s.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},(0,d.jsx)(s.EuiFlexItem,{grow:!1},(0,d.jsx)(s.EuiText,null,(0,d.jsx)("p",null,(0,d.jsx)(c.FormattedMessage,{id:"xpack.apm.onboarding.footer.exploreYourDataDescription",defaultMessage:"When all steps are complete, you're ready to explore your data."})))),(0,d.jsx)(s.EuiFlexItem,{grow:!1},(0,d.jsx)(s.EuiButton,{"data-test-subj":"apmTutorialFooterButton",fill:!0,href:e},u.i18n.translate("xpack.apm.onboarding.footer.cta",{defaultMessage:"Launch APM"})))))}var me=n(32336);function ke(){const[e,a]=(0,t.useState)([]),[n,i]=(0,t.useState)({apiKey:null,error:!1}),[u,c]=(0,t.useState)(!1),[p,m]=(0,t.useState)(),[y,f]=(0,t.useState)(!1),{services:v}=(0,r.useKibana)(),{config:x}=(0,o.W)(),{docLinks:A,observabilityShared:S}=v,E=(null==A?void 0:A.links.kibana.guide)||"https://www.elastic.co/guide/en/kibana/current/index.html",b=(null==A?void 0:A.ELASTIC_WEBSITE_URL)||"https://www.elastic.co/",M=async()=>{try{c(!0);const e=[me.i_.EVENT],{agentKey:a}=await(0,l.L)("POST /api/apm/agent_keys 2023-10-31",{signal:null,params:{body:{name:`onboarding-${(Math.random()+1).toString(36).substring(7)}`,privileges:e}}});i({apiKey:a.encoded,id:a.id,error:!1})}catch(a){var e;i({apiKey:null,error:!0,errorMessage:(null===(e=a.body)||void 0===e?void 0:e.message)||a.message})}finally{c(!1)}},j=async()=>{try{f(!0);const e=await(0,l.L)("GET /internal/apm/observability_overview/has_data",{signal:null});m(e.hasData)}catch(e){m(!1)}finally{f(!1)}},K=e.length>0;(0,t.useEffect)((()=>{a(function({baseUrl:e,config:a,checkAgentStatus:n,agentStatus:t,agentStatusLoading:i},r,s,l){const{apiKey:o,error:u,errorMessage:c}=s,p=Boolean(o)&&!u,d=u&&Boolean(c),g={baseUrl:e,apmServerUrl:`${a.managedServiceUrl}:443`,checkAgentStatus:n,agentStatus:t,agentStatusLoading:i,apiKeyDetails:{...s,displayApiKeySuccessCallout:p,displayApiKeyErrorCallout:d,createAgentKey:l,createApiKeyLoading:r}};return[{title:de,id:k.X.NODE,instructions:ie(g)},{title:de,id:k.X.DJANGO,instructions:re(g)},{title:de,id:k.X.FLASK,instructions:se(g)},{title:de,id:k.X.RAILS,instructions:le(g)},{title:de,id:k.X.RACK,instructions:oe(g)},{title:de,id:k.X.GO,instructions:ue(g)},{title:de,id:k.X.JAVA,instructions:te(g)},{title:de,id:k.X.DOTNET,instructions:ce(g)},{title:de,id:k.X.PHP,instructions:pe(g)}]}({baseUrl:b,config:x,checkAgentStatus:j,agentStatus:p,agentStatusLoading:y},u,n,M))}),[n,b,x,u,p,y]);const C=S.navigation.PageTemplate;return(0,d.jsx)(C,null,(0,d.jsx)(g,{isBeta:!1,guideLink:E}),(0,d.jsx)(s.EuiSpacer,null),K&&(0,d.jsx)(h,{instructions:e}),(0,d.jsx)(s.EuiSpacer,null),(0,d.jsx)(ge,null))}}}]);