"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RELATED_GRAPH_PATH = exports.PLUGIN_ID = exports.NAME_REGEX_PATTERN = exports.MINIMUM_LICENSE_TYPE = exports.LOG_FORMAT_DETECTION_SAMPLE_ROWS = exports.INTEGRATION_BUILDER_PATH = exports.GenerationErrorCode = exports.FRONTEND_SAMPLE_ROWS = exports.FLEET_PACKAGES_PATH = exports.ECS_GRAPH_PATH = exports.DATASTREAM_NAME_REGEX_PATTERN = exports.CHECK_PIPELINE_PATH = exports.CEL_INPUT_GRAPH_PATH = exports.CATEROGIZATION_REVIEW_BATCH_SIZE = exports.CATEGORIZATION_REVIEW_MAX_CYCLES = exports.CATEGORIZATION_RECURSION_LIMIT = exports.CATEGORIZATION_INITIAL_BATCH_SIZE = exports.CATEGORIZATION_GRAPH_PATH = exports.AUTOMATIC_IMPORT_BASE_PATH = exports.AUTOMATIC_IMPORT_APP_ROUTE = exports.ANALYZE_LOGS_PATH = exports.ANALYZE_API_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Plugin information
const PLUGIN_ID = exports.PLUGIN_ID = 'automaticImport';

// Public App Routes
const AUTOMATIC_IMPORT_APP_ROUTE = exports.AUTOMATIC_IMPORT_APP_ROUTE = '/app/automatic_import';

// Server API Routes
const AUTOMATIC_IMPORT_BASE_PATH = exports.AUTOMATIC_IMPORT_BASE_PATH = '/internal/automatic_import';
const ECS_GRAPH_PATH = exports.ECS_GRAPH_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/ecs`;
const CATEGORIZATION_GRAPH_PATH = exports.CATEGORIZATION_GRAPH_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/categorization`;
const ANALYZE_LOGS_PATH = exports.ANALYZE_LOGS_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/analyzelogs`;
const RELATED_GRAPH_PATH = exports.RELATED_GRAPH_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/related`;
const ANALYZE_API_PATH = exports.ANALYZE_API_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/analyzeapi`;
const CEL_INPUT_GRAPH_PATH = exports.CEL_INPUT_GRAPH_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/cel`;
const CHECK_PIPELINE_PATH = exports.CHECK_PIPELINE_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/pipeline`;
const INTEGRATION_BUILDER_PATH = exports.INTEGRATION_BUILDER_PATH = `${AUTOMATIC_IMPORT_BASE_PATH}/build`;
const FLEET_PACKAGES_PATH = exports.FLEET_PACKAGES_PATH = `/api/fleet/epm/packages`;

// License
const MINIMUM_LICENSE_TYPE = exports.MINIMUM_LICENSE_TYPE = 'enterprise';

// ErrorCodes
let GenerationErrorCode = exports.GenerationErrorCode = /*#__PURE__*/function (GenerationErrorCode) {
  GenerationErrorCode["RECURSION_LIMIT"] = "recursion-limit";
  GenerationErrorCode["RECURSION_LIMIT_ANALYZE_LOGS"] = "recursion-limit-analyze-logs";
  GenerationErrorCode["UNSUPPORTED_LOG_SAMPLES_FORMAT"] = "unsupported-log-samples-format";
  GenerationErrorCode["UNPARSEABLE_CSV_DATA"] = "unparseable-csv-data";
  GenerationErrorCode["CEF_ERROR"] = "cef-not-supported";
  GenerationErrorCode["BUILD_INTEGRATION_ERROR"] = "build-integration-error";
  return GenerationErrorCode;
}({}); // Size limits
const FRONTEND_SAMPLE_ROWS = exports.FRONTEND_SAMPLE_ROWS = 100;
const LOG_FORMAT_DETECTION_SAMPLE_ROWS = exports.LOG_FORMAT_DETECTION_SAMPLE_ROWS = 5;
const CATEGORIZATION_INITIAL_BATCH_SIZE = exports.CATEGORIZATION_INITIAL_BATCH_SIZE = 60;
const CATEROGIZATION_REVIEW_BATCH_SIZE = exports.CATEROGIZATION_REVIEW_BATCH_SIZE = 40;
const CATEGORIZATION_REVIEW_MAX_CYCLES = exports.CATEGORIZATION_REVIEW_MAX_CYCLES = 5;
const CATEGORIZATION_RECURSION_LIMIT = exports.CATEGORIZATION_RECURSION_LIMIT = 50;

// Name regex pattern
const NAME_REGEX_PATTERN = exports.NAME_REGEX_PATTERN = /^[a-z_][a-z0-9_]+$/;

// Datastream name regex pattern. Same regex that for the name validation in elastic-package
const DATASTREAM_NAME_REGEX_PATTERN = exports.DATASTREAM_NAME_REGEX_PATTERN = /^([a-z0-9]{2}|[a-z0-9][a-z0-9_]+[a-z0-9])$/;