"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiDefinitionInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _oas = _interopRequireDefault(require("oas"));
var _jsYaml = _interopRequireDefault(require("js-yaml"));
var i18n = _interopRequireWildcard(require("./translations"));
var _state = require("../../../../state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/automatic_import/public/components/create_integration/create_automatic_import/flyout/cel_configuration/steps/upload_spec_step/api_definition_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Prepares the OpenAPI specification file to send to the backend from the user-uploaded file.
 *
 * This function will return an error message if the uploaded API definition cannot be parsed into an OAS Document
 * from the uploaded JSON or YAML defintion file.
 *
 * @param fileContent The content of the user-provided API definition file.
 * @returns The parsed OAS object or an error message.
 */
const prepareOas = fileContent => {
  let parsedApiSpec;
  try {
    parsedApiSpec = new _oas.default(fileContent);
  } catch (parseJsonOasError) {
    try {
      const specYaml = _jsYaml.default.load(fileContent);
      const specJson = JSON.stringify(specYaml);
      parsedApiSpec = new _oas.default(specJson);
    } catch (parseYamlOasError) {
      return {
        error: i18n.API_DEFINITION_ERROR.INVALID_OAS
      };
    }
  }
  return {
    oas: parsedApiSpec
  };
};
const ApiDefinitionInput = exports.ApiDefinitionInput = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  showValidation,
  isGenerating,
  onModifySpecFile
}) => {
  const {
    setIntegrationSettings
  } = (0, _state.useActions)();
  const [uploadedFile, setUploadedFile] = (0, _react.useState)(undefined);
  const [isParsing, setIsParsing] = (0, _react.useState)(false);
  const [apiFileError, setApiFileError] = (0, _react.useState)();
  const onChangeApiDefinition = (0, _react.useCallback)(files => {
    if (!files || files.length === 0) {
      setUploadedFile(undefined);
      onModifySpecFile(false);
      return;
    }
    setUploadedFile(files);
    setApiFileError(undefined);
    setIntegrationSettings({
      ...integrationSettings,
      apiSpec: undefined,
      apiSpecFileName: undefined
    });
    const apiDefinitionFile = files[0];
    const reader = new FileReader();
    reader.onloadstart = function () {
      setIsParsing(true);
    };
    reader.onloadend = function () {
      setIsParsing(false);
    };
    reader.onload = function (e) {
      var _e$target;
      const fileContent = (_e$target = e.target) === null || _e$target === void 0 ? void 0 : _e$target.result; // We can safely cast to string since we call `readAsText` to load the file.

      if (fileContent == null) {
        setApiFileError(i18n.API_DEFINITION_ERROR.CAN_NOT_READ);
        onModifySpecFile(false);
        return;
      }
      if (fileContent === '' && e.loaded > 100000) {
        // V8-based browsers can't handle large files and return an empty string
        // instead of an error; see https://stackoverflow.com/a/61316641
        setApiFileError(i18n.API_DEFINITION_ERROR.TOO_LARGE_TO_PARSE);
        onModifySpecFile(false);
        return;
      }
      const prepareResult = prepareOas(fileContent);
      if ('error' in prepareResult) {
        setApiFileError(prepareResult.error);
        onModifySpecFile(false);
        return;
      }
      const {
        oas
      } = prepareResult;
      const oasPaths = oas.getPaths();

      // Verify we have valid GET paths in the uploaded spec file
      if (Object.values(oasPaths).filter(path => path === null || path === void 0 ? void 0 : path.get).length === 0) {
        setApiFileError(i18n.API_DEFINITION_ERROR.NO_PATHS_IDENTIFIED);
        onModifySpecFile(false);
      }
      setIntegrationSettings({
        ...integrationSettings,
        apiSpec: oas,
        apiSpecFileName: apiDefinitionFile.name
      });
    };
    const handleReaderError = function () {
      var _reader$error;
      const message = (_reader$error = reader.error) === null || _reader$error === void 0 ? void 0 : _reader$error.message;
      if (message) {
        setApiFileError(i18n.API_DEFINITION_ERROR.CAN_NOT_READ_WITH_REASON(message));
      } else {
        setApiFileError(i18n.API_DEFINITION_ERROR.CAN_NOT_READ);
      }
    };
    reader.onerror = handleReaderError;
    reader.onabort = handleReaderError;
    reader.readAsText(apiDefinitionFile);
    onModifySpecFile(true);
  }, [setIntegrationSettings, integrationSettings, onModifySpecFile]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isDisabled: isGenerating,
    label: i18n.API_DEFINITION_TITLE,
    isInvalid: apiFileError != null || showValidation && uploadedFile === undefined,
    error: apiFileError ? apiFileError : i18n.SPEC_FILE_REQUIRED,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }, i18n.OPEN_API_UPLOAD_INSTRUCTIONS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "apiDefinitionFilePicker",
    fullWidth: true,
    initialPromptText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 17
      }
    }, i18n.API_DEFINITION_DESCRIPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      textAlign: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 17
      }
    }, i18n.API_DEFINITION_DESCRIPTION_2)),
    onChange: onChangeApiDefinition,
    display: "large",
    "aria-label": "Upload API definition file",
    "data-loading": isParsing || isGenerating,
    isLoading: isParsing || isGenerating,
    isInvalid: apiFileError != null || showValidation && uploadedFile === undefined,
    "data-test-subj": "apiDefinitionFilePicker",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  })));
});
ApiDefinitionInput.displayName = 'ApiDefinitionInput';