"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleRemoveHeadersDigest = handleRemoveHeadersDigest;
var _output_parsers = require("@langchain/core/output_parsers");
var _constants = require("./constants");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleRemoveHeadersDigest({
  state,
  model
}) {
  const outputParser = new _output_parsers.StringOutputParser();
  const updateCelProgramDigestGraph = _prompts.CEL_AUTH_DIGEST_PROMPT.pipe(model).pipe(outputParser);
  const updatedProgram = await updateCelProgramDigestGraph.invoke({
    cel_program: state.currentProgram,
    example_cel_programs: _constants.SAMPLE_CEL_PROGRAMS
  });
  return {
    currentProgram: updatedProgram.trim(),
    lastExecutedChain: 'removeHeadersDigest'
  };
}