"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCelGraph = getCelGraph;
var _langgraph = require("@langchain/langgraph");
var _cel_input_attributes = require("../../../common/api/model/cel_input_attributes.gen");
var _build_program = require("./build_program");
var _analyze_headers = require("./analyze_headers");
var _auth_header = require("./auth_header");
var _auth_basic = require("./auth_basic");
var _auth_oauth = require("./auth_oauth2");
var _auth_digest = require("./auth_digest");
var _retrieve_state_details = require("./retrieve_state_details");
var _retrieve_state_vars = require("./retrieve_state_vars");
var _summarize_query = require("./summarize_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  apiQuerySummary: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  currentProgram: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  hasProgramHeaders: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => undefined
  },
  stateVarNames: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  stateSettings: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  configFields: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  redactVars: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  authType: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => 'header'
  },
  path: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  openApiPathDetails: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  openApiSchemas: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  openApiAuthSchema: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  }
};
function modelInput({
  state
}) {
  const input = {
    finalized: false,
    lastExecutedChain: 'modelInput',
    path: state.path,
    authType: state.authType,
    openApiPathDetails: state.openApiPathDetails,
    openApiSchemas: state.openApiSchemas,
    openApiAuthSchema: state.openApiAuthSchema,
    dataStreamName: state.dataStreamName
  };
  return input;
}
function modelOutput({
  state
}) {
  const needsAuthConfigBlock = !state.hasProgramHeaders && state.authType !== 'header';
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      program: state.currentProgram,
      stateSettings: state.stateSettings,
      configFields: state.configFields,
      redactVars: state.redactVars,
      needsAuthConfigBlock
    }
  };
}
function headerAuthRouter({
  state
}) {
  if (state.authType === _cel_input_attributes.CelAuthTypeEnum.header) {
    return 'headerAuthUpdate';
  }
  return 'analyzeProgramForExistingHeaders';
}
function authRouter({
  state
}) {
  if (state.authType === _cel_input_attributes.CelAuthTypeEnum.oauth2 && state.hasProgramHeaders) {
    return 'oauth2Update';
  }
  if (state.authType === _cel_input_attributes.CelAuthTypeEnum.basic && state.hasProgramHeaders) {
    return 'basicUpdate';
  }
  if (state.authType === _cel_input_attributes.CelAuthTypeEnum.digest && state.hasProgramHeaders) {
    return 'digestUpdate';
  }
  return 'noExistingHeaders';
}
async function getCelGraph({
  model
}) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', state => modelInput({
    state
  })).addNode('handleSummarizeQuery', state => (0, _summarize_query.handleSummarizeQuery)({
    state,
    model
  })).addNode('handleBuildProgram', state => (0, _build_program.handleBuildProgram)({
    state,
    model
  })).addNode('handleAnalyzeProgramHeaders', state => (0, _analyze_headers.handleAnalyzeHeaders)({
    state,
    model
  })).addNode('handleUpdateProgramHeaderAuth', state => (0, _auth_header.handleUpdateProgramHeaderAuth)({
    state,
    model
  })).addNode('handleUpdateProgramBasic', state => (0, _auth_basic.handleUpdateProgramBasic)({
    state,
    model
  })).addNode('handleUpdateProgramOauth2', state => (0, _auth_oauth.handleUpdateProgramOauth2)({
    state,
    model
  })).addNode('handleRemoveHeadersDigest', state => (0, _auth_digest.handleRemoveHeadersDigest)({
    state,
    model
  })).addNode('handleGetStateVariables', state => (0, _retrieve_state_vars.handleGetStateVariables)({
    state,
    model
  })).addNode('handleGetStateDetails', state => (0, _retrieve_state_details.handleGetStateDetails)({
    state,
    model
  })).addNode('modelOutput', state => modelOutput({
    state
  })).addEdge(_langgraph.START, 'modelInput').addEdge('modelOutput', _langgraph.END).addEdge('modelInput', 'handleSummarizeQuery').addEdge('handleSummarizeQuery', 'handleBuildProgram').addEdge('handleUpdateProgramHeaderAuth', 'handleGetStateVariables').addEdge('handleUpdateProgramOauth2', 'handleGetStateVariables').addEdge('handleUpdateProgramBasic', 'handleGetStateVariables').addEdge('handleRemoveHeadersDigest', 'handleGetStateVariables').addEdge('handleGetStateVariables', 'handleGetStateDetails').addEdge('handleGetStateDetails', 'modelOutput').addConditionalEdges('handleBuildProgram', state => headerAuthRouter({
    state
  }), {
    headerAuthUpdate: 'handleUpdateProgramHeaderAuth',
    analyzeProgramForExistingHeaders: 'handleAnalyzeProgramHeaders'
  }).addConditionalEdges('handleAnalyzeProgramHeaders', state => authRouter({
    state
  }), {
    oauth2Update: 'handleUpdateProgramOauth2',
    basicUpdate: 'handleUpdateProgramBasic',
    digestUpdate: 'handleRemoveHeadersDigest',
    noExistingHeaders: 'handleGetStateVariables'
  });
  const compiledCelGraph = workflow.compile();
  return compiledCelGraph;
}