"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerIntegrationBuilderRoutes = registerIntegrationBuilderRoutes;
var _common = require("../../common");
var _integration_builder = require("../integration_builder");
var _route_validation = require("../util/route_validation");
var _with_availability = require("./with_availability");
var _errors = require("../lib/errors");
var _routes_util = require("./routes_util");
var _constants = require("../../common/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerIntegrationBuilderRoutes(router) {
  router.versioned.post({
    path: _common.INTEGRATION_BUILDER_PATH,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: [_constants2.FLEET_ALL_ROLE, _constants2.INTEGRATIONS_ALL_ROLE]
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidationWithZod)(_common.BuildIntegrationRequestBody)
      }
    }
  }, (0, _with_availability.withAvailability)(async (_, request, response) => {
    const {
      integration
    } = request.body;
    try {
      const zippedIntegration = await (0, _integration_builder.buildPackage)(integration);
      return response.custom({
        statusCode: 200,
        body: zippedIntegration,
        headers: {
          'Content-Type': 'application/zip'
        }
      });
    } catch (err) {
      try {
        (0, _routes_util.handleCustomErrors)(err, _constants.GenerationErrorCode.RECURSION_LIMIT);
      } catch (e) {
        if ((0, _errors.isErrorThatHandlesItsOwnResponse)(e)) {
          return e.sendResponse(response);
        }
      }
      return response.customError({
        statusCode: 500,
        body: err
      });
    }
  }));
}