"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UploadSamplesToDataStreamResponse = exports.UploadSamplesToDataStreamRequestParams = exports.UploadSamplesToDataStreamRequestBody = exports.StopAutoImportDataStreamRequestParams = exports.DeleteDataStreamRequestParams = void 0;
var _zod = require("@kbn/zod");
var _primitive = require("../../primitive.gen");
var _common_attributes = require("../../common_attributes.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Automatic Import Integrations API endpoint
 *   version: 1
 */

const DeleteDataStreamRequestParams = exports.DeleteDataStreamRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString,
  /**
   * The data stream identifier
   */
  data_stream_id: _primitive.NonEmptyString
});
const StopAutoImportDataStreamRequestParams = exports.StopAutoImportDataStreamRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString,
  /**
   * The data stream identifier
   */
  data_stream_id: _primitive.NonEmptyString
});
const UploadSamplesToDataStreamRequestParams = exports.UploadSamplesToDataStreamRequestParams = _zod.z.object({
  /**
   * The integration identifier
   */
  integration_id: _primitive.NonEmptyString,
  /**
   * The data stream identifier
   */
  data_stream_id: _primitive.NonEmptyString
});
const UploadSamplesToDataStreamRequestBody = exports.UploadSamplesToDataStreamRequestBody = _zod.z.object({
  /**
   * The samples to upload
   */
  samples: _zod.z.array(_zod.z.string()),
  /**
   * The original source of the samples
   */
  originalSource: _common_attributes.OriginalSource
});
const UploadSamplesToDataStreamResponse = exports.UploadSamplesToDataStreamResponse = _zod.z.object({
  /**
   * Indicates if the samples are uploaded successfully.
   */
  success: _zod.z.boolean().optional()
}).strict();