"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TaskStatusEnum = exports.TaskStatus = exports.OriginalSourceTypeEnum = exports.OriginalSourceType = exports.OriginalSource = exports.IntegrationResponse = exports.Integration = exports.InputType = exports.DataStreamResponse = exports.DataStream = exports.AllIntegrationsResponseIntegration = void 0;
var _zod = require("@kbn/zod");
var _primitive = require("./primitive.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Automatic Import Common Attributes Model
 *   version: not applicable
 */

/**
 * The input type object with its settings.
 */

const InputType = exports.InputType = _zod.z.object({
  /**
   * The name of the input type
   */
  name: _zod.z.enum(['aws-cloudwatch', 'aws-s3', 'azure-blob-storage', 'azure-eventhub', 'cloudfoundry', 'filestream', 'gcp-pubsub', 'gcs', 'http_endpoint', 'journald', 'kafka', 'tcp', 'udp'])
});

/**
 * The data stream object with its settings.
 */

const DataStream = exports.DataStream = _zod.z.object({
  /**
   * The ID of the data stream
   */
  dataStreamId: _primitive.NonEmptyString,
  /**
   * The title of the data stream
   */
  title: _primitive.NonEmptyString,
  /**
   * The description of the data stream
   */
  description: _primitive.NonEmptyString,
  /**
   * The input types of the data stream
   */
  inputTypes: _zod.z.array(InputType)
});

/**
 * The integration object with its settings.
 */

const Integration = exports.Integration = _zod.z.object({
  /**
   * The ID of the integration
   */
  integrationId: _primitive.NonEmptyString,
  /**
   * The data streams of the integration
   */
  dataStreams: _zod.z.array(DataStream).optional(),
  /**
   * The logo of the integration
   */
  logo: _zod.z.string().optional(),
  /**
   * The description of the integration
   */
  description: _primitive.NonEmptyString,
  /**
   * The title of the integration
   */
  title: _primitive.NonEmptyString
}).strict();

/**
 * The type of the original source.
 */

const OriginalSourceType = exports.OriginalSourceType = _zod.z.enum(['index', 'file']);
const OriginalSourceTypeEnum = exports.OriginalSourceTypeEnum = OriginalSourceType.enum;

/**
 * The original source of the samples.
 */

const OriginalSource = exports.OriginalSource = _zod.z.object({
  /**
   * The type of the original source
   */
  sourceType: OriginalSourceType,
  /**
   * The value of the original source (e.g. index name or filename)
   */
  sourceValue: _primitive.NonEmptyString
});

/**
 * The status of the task
 */

const TaskStatus = exports.TaskStatus = _zod.z.enum(['pending', 'processing', 'completed', 'failed', 'cancelled']);
const TaskStatusEnum = exports.TaskStatusEnum = TaskStatus.enum;

/**
 * The data stream response object with its settings.
 */

const DataStreamResponse = exports.DataStreamResponse = _zod.z.object({
  /**
   * The ID of the data stream
   */
  dataStreamId: _primitive.NonEmptyString,
  /**
   * The title of the data stream
   */
  title: _primitive.NonEmptyString,
  /**
   * The description of the data stream
   */
  description: _primitive.NonEmptyString,
  /**
   * The input types of the data stream
   */
  inputTypes: _zod.z.array(InputType),
  /**
   * The status of the data stream
   */
  status: TaskStatus
});

/**
 * The integration response object with its settings.
 */

const IntegrationResponse = exports.IntegrationResponse = _zod.z.object({
  /**
   * The ID of the integration
   */
  integrationId: _primitive.NonEmptyString,
  /**
   * The title of the integration
   */
  title: _primitive.NonEmptyString,
  /**
   * The logo of the integration
   */
  logo: _zod.z.string().optional(),
  /**
   * The description of the integration
   */
  description: _primitive.NonEmptyString,
  /**
   * The data streams of the integration
   */
  dataStreams: _zod.z.array(DataStreamResponse),
  /**
   * The status of the integration
   */
  status: TaskStatus
});

/**
 * The integration object with its settings.
 */

const AllIntegrationsResponseIntegration = exports.AllIntegrationsResponseIntegration = _zod.z.object({
  /**
   * The ID of the integration
   */
  integrationId: _primitive.NonEmptyString,
  /**
   * The title of the integration
   */
  title: _primitive.NonEmptyString,
  /**
   * The number of data streams of the integration
   */
  totalDataStreamCount: _zod.z.number().int(),
  /**
   * The number of successful data streams of the integration
   */
  successfulDataStreamCount: _zod.z.number().int(),
  /**
   * The status of the integration
   */
  status: TaskStatus
});