"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomaticImportAgentState = void 0;
var _langgraph = require("@langchain/langgraph");
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutomaticImportAgentState = exports.AutomaticImportAgentState = _langgraph.MessagesZodState.extend({
  current_pipeline: _zod.z.object({
    processors: _zod.z.array(_zod.z.any()).describe('The processors in the pipeline'),
    on_failure: _zod.z.array(_zod.z.any()).optional().describe('Optional failure handlers for the pipeline')
  }).describe('The generated ingest pipeline to validate'),
  pipeline_generation_results: _zod.z.object({
    docs: _zod.z.array(_zod.z.object({
      doc: _zod.z.object({
        _source: _zod.z.record(_zod.z.any())
      })
    })).default([])
  }).default({
    docs: []
  }),
  failure_count: _zod.z.number().min(0).default(0),
  pipeline_validation_results: _zod.z.object({
    success_rate: _zod.z.number().min(0).max(100).default(100),
    successful_samples: _zod.z.number().min(0).default(0),
    failed_samples: _zod.z.number().min(0).default(0),
    total_samples: _zod.z.number().min(0).default(0),
    failure_details: _zod.z.array(_zod.z.object({
      error: _zod.z.string(),
      sample: _zod.z.string()
    })).max(100).default([])
  }).default({
    success_rate: 100,
    successful_samples: 0,
    failed_samples: 0,
    total_samples: 0,
    failure_details: []
  })
});