"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestContextFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RequestContextFactory {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.options = options;
    this.logger = options.logger;
  }
  async create(context, request) {
    const {
      options
    } = this;
    const {
      core
    } = options;
    const [coreStart, startPlugins] = await core.getStartServices();
    const coreContext = await context.core;
    const getSpaceId = () => {
      var _startPlugins$spaces, _startPlugins$spaces$;
      return ((_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : (_startPlugins$spaces$ = _startPlugins$spaces.spacesService) === null || _startPlugins$spaces$ === void 0 ? void 0 : _startPlugins$spaces$.getSpaceId(request)) || _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING;
    };
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    const esClient = coreContext.elasticsearch.client.asCurrentUser;
    return {
      core: coreContext,
      actions: startPlugins.actions,
      logger: this.logger,
      getServerBasePath: () => core.http.basePath.serverBasePath,
      getSpaceId,
      getCurrentUser: async () => {
        const user = await coreContext.security.authc.getCurrentUser();
        if (!user) {
          // Return a default system user for testing/non-authenticated environments
          return {
            username: 'system',
            roles: [],
            enabled: true,
            authentication_realm: {
              name: 'reserved',
              type: 'reserved'
            },
            lookup_realm: {
              name: 'reserved',
              type: 'reserved'
            },
            authentication_provider: {
              type: 'basic',
              name: 'basic'
            },
            authentication_type: 'realm',
            elastic_cloud_user: false
          };
        }
        return user;
      },
      automaticImportService: this.options.automaticImportService,
      inference: startPlugins.inference,
      savedObjectsClient,
      esClient
    };
  }
}
exports.RequestContextFactory = RequestContextFactory;