"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.integrationSchemaV1 = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationSchemaV1 = exports.integrationSchemaV1 = _configSchema.schema.object({
  integration_id: _configSchema.schema.string({
    maxLength: _constants2.MAX_ID_LENGTH,
    minLength: 1
  }),
  data_stream_count: _configSchema.schema.maybe(_configSchema.schema.number()),
  created_by: _configSchema.schema.string({
    minLength: 1
  }),
  status: _configSchema.schema.oneOf(Object.values(_constants.TASK_STATUSES).map(status => _configSchema.schema.literal(status))),
  metadata: _configSchema.schema.object({
    title: _configSchema.schema.string(),
    version: _configSchema.schema.maybe(_configSchema.schema.string({
      minLength: _constants2.MIN_VERSION_LENGTH,
      maxLength: _constants2.MAX_VERSION_LENGTH,
      validate(value) {
        if (!/^\d+\.\d+\.\d+$/.test(value)) {
          return 'version must be in semantic versioning format (x.y.z)';
        }
      }
    })),
    logo: _configSchema.schema.maybe(_configSchema.schema.string()),
    description: _configSchema.schema.string(),
    created_at: _configSchema.schema.maybe(_configSchema.schema.string())
    // allow other fields not explicitly defined here
  }, {
    unknowns: 'allow'
  })
});