"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.range = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _template_from_react_component = require("../../../public/lib/template_from_react_component");
var _with_debounce_arg = require("../../../public/components/with_debounce_arg");
var _i18n = require("../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/uis/arguments/range.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  Range: strings
} = _i18n.ArgumentStrings;
const RangeArgInput = ({
  typeInstance,
  onValueChange,
  argValue
}) => {
  const {
    min,
    max,
    step
  } = typeInstance.options;
  const [value, setValue] = (0, _react.useState)(argValue);
  const handleChange = (0, _react.useCallback)(ev => {
    const {
      value
    } = ev.target;
    const numberVal = Number(value);
    setValue(numberVal);
    onValueChange(numberVal);
  }, [onValueChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    min: min,
    max: max,
    step: step,
    showLabels: true,
    showInput: true,
    value: value,
    onChange: handleChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
};
RangeArgInput.propTypes = {
  onValueChange: _propTypes.default.func.isRequired,
  argValue: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]).isRequired,
  typeInstance: _propTypes.default.shape({
    options: _propTypes.default.shape({
      min: _propTypes.default.number.isRequired,
      max: _propTypes.default.number.isRequired,
      step: _propTypes.default.number
    }).isRequired
  }),
  argId: _propTypes.default.string.isRequired
};
const range = () => ({
  name: 'range',
  displayName: strings.getDisplayName(),
  help: strings.getHelp(),
  simpleTemplate: (0, _template_from_react_component.templateFromReactComponent)((0, _with_debounce_arg.withDebounceArg)(RangeArgInput, 50))
});
exports.range = range;