"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetManager = void 0;
var _reactRedux = require("react-redux");
var _lodash = require("lodash");
var _lib = require("../../lib");
var _find_existing_asset = require("../../lib/find_existing_asset");
var _constants = require("../../../common/lib/constants");
var _assets = require("../../lib/assets");
var _assets2 = require("../../state/selectors/assets");
var _assets3 = require("../../state/actions/assets");
var _asset_manager = require("./asset_manager.component");
var _workpad = require("../../state/selectors/workpad");
var _canvas_workpad_service = require("../../services/canvas_workpad_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error untyped local

// @ts-expect-error untyped local

const AssetManager = exports.AssetManager = (0, _reactRedux.connect)(state => ({
  assets: (0, _assets2.getAssets)(state),
  workpad: (0, _workpad.getFullWorkpadPersisted)(state)
}), dispatch => ({
  onAddAsset: (workpad, type, content) => {
    // make the ID here and pass it into the action
    const asset = (0, _assets.createAsset)(type, content);
    const workpadService = (0, _canvas_workpad_service.getCanvasWorkpadService)();
    return workpadService.updateAssets(workpad.id, {
      ...workpad.assets,
      [asset.id]: asset
    }).then(res => {
      dispatch((0, _assets3.setAsset)(asset));
      // then return the id, so the caller knows the id that will be created
      return asset.id;
    }).catch(error => (0, _assets.notifyError)(error));
  }
}), (stateProps, dispatchProps, ownProps) => {
  const {
    assets,
    workpad
  } = stateProps;
  const {
    onAddAsset
  } = dispatchProps;

  // pull values out of assets object
  // have to cast to AssetType[] because TS doesn't know about filtering
  const assetValues = Object.values(assets).filter(asset => !!asset);
  return {
    ...ownProps,
    assets: assetValues,
    onAddAsset: async file => {
      const [type, subtype] = (0, _lodash.get)(file, 'type', '').split('/');
      if (type === 'image' && _constants.VALID_IMAGE_TYPES.indexOf(subtype) >= 0) {
        return await (0, _lib.encode)(file).then(dataurl => {
          const dataurlType = 'dataurl';
          const existingId = (0, _find_existing_asset.findExistingAsset)(dataurlType, dataurl, assetValues);
          if (existingId) {
            return existingId;
          }
          return onAddAsset(workpad, dataurlType, dataurl);
        });
      }
    }
  };
})(_asset_manager.AssetManager);