"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _workpad = require("../../state/selectors/workpad");
var _element_content = require("./element_content");
var _canvas_expressions_service = require("../../services/canvas_expressions_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/element_content/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ElementContent = props => {
  const selectedPageId = (0, _reactRedux.useSelector)(_workpad.getSelectedPage);
  const selectedElementId = (0, _reactRedux.useSelector)(_workpad.getSelectedElementId);
  const backgroundColor = (0, _reactRedux.useSelector)(state => {
    var _getPageById;
    return (_getPageById = (0, _workpad.getPageById)(state, selectedPageId)) === null || _getPageById === void 0 ? void 0 : _getPageById.style.background;
  }) || '';
  const {
    renderable
  } = props;
  const renderFunction = (0, _react.useMemo)(() => {
    return renderable ? (0, _canvas_expressions_service.getCanvasExpressionService)().getRenderer(renderable.as) : null;
  }, [renderable]);
  return /*#__PURE__*/_react.default.createElement(_element_content.ElementContent, (0, _extends2.default)({}, props, {
    renderFunction,
    backgroundColor,
    selectedElementId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 10
    }
  }));
};
exports.ElementContent = ElementContent;