"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.errorBoundaryHoc = exports.ErrorBoundary = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRecompose = require("react-recompose");
var _propTypes = _interopRequireDefault(require("prop-types"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorBoundaryComponent = props => {
  const {
    children,
    ...rest
  } = props;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(rest));
};
ErrorBoundaryComponent.propTypes = {
  children: _propTypes.default.func.isRequired,
  // @ts-expect-error upgrade typescript v5.9.3
  error: _propTypes.default.object,
  errorInfo: _propTypes.default.object,
  resetErrorState: _propTypes.default.func.isRequired
};
const errorBoundaryHoc = exports.errorBoundaryHoc = (0, _reactRecompose.compose)((0, _reactRecompose.withState)('error', 'setError', null), (0, _reactRecompose.withState)('errorInfo', 'setErrorInfo', null), (0, _reactRecompose.withHandlers)({
  resetErrorState: ({
    setError,
    setErrorInfo
  }) => () => {
    setError(null);
    setErrorInfo(null);
  }
}), (0, _reactRecompose.lifecycle)({
  componentDidCatch(error, errorInfo) {
    this.props.setError(error);
    this.props.setErrorInfo(errorInfo);
  }
}), (0, _reactRecompose.mapProps)(props => (0, _lodash.omit)(props, ['setError', 'setErrorInfo'])));
const ErrorBoundary = exports.ErrorBoundary = errorBoundaryHoc(ErrorBoundaryComponent);