"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RotationHandle = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _dom = require("../../lib/dom");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/components/layout_annotations/rotation_handle.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RotationHandle = ({
  transformMatrix,
  zoomScale = 1
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasRotationHandle canvasLayoutAnnotation",
  style: {
    transform: (0, _dom.matrixToCSS)(transformMatrix)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement("div", {
  className: "canvasRotationHandle__handle",
  style: {
    transform: `scale3d(${1 / zoomScale},${1 / zoomScale},1)`
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 5
  }
}));
exports.RotationHandle = RotationHandle;
RotationHandle.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  transformMatrix: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
  zoomScale: _propTypes.default.number
};