"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtendedTemplate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _objectPathImmutable = require("object-path-immutable");
var _lodash = require("lodash");
var _i18n = require("../../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/canvas/public/expression_types/arg_types/series_style/extended_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  SeriesStyle: strings
} = _i18n.ArgTypesStrings;
const ExtendedTemplate = props => {
  const {
    typeInstance,
    onValueChange,
    resolved: {
      labels
    },
    argValue
  } = props;
  const chain = (0, _lodash.get)(argValue, 'chain.0', {});
  const chainArgs = (0, _lodash.get)(chain, 'arguments', {});
  const selectedSeries = (0, _lodash.get)(chainArgs, 'label.0', '');
  let name = '';
  if (typeInstance) {
    name = typeInstance.name;
  }
  const fields = (0, _lodash.get)(typeInstance, 'options.include', []);
  const hasPropFields = fields.some(field => ['lines', 'bars', 'points'].indexOf(field) !== -1);
  const handleChange = (argName, ev) => {
    const fn = ev.target.value === '' ? _objectPathImmutable.del : _objectPathImmutable.set;
    const newValue = fn(argValue, `chain.0.arguments.${argName}`, [ev.target.value]);
    return onValueChange(newValue);
  };

  // TODO: add fill and stack options
  // TODO: add label name auto-complete
  const values = [{
    value: 0,
    text: strings.getNoneOption()
  }, {
    value: 1,
    text: '1'
  }, {
    value: 2,
    text: '2'
  }, {
    value: 3,
    text: '3'
  }, {
    value: 4,
    text: '4'
  }, {
    value: 5,
    text: '5'
  }];
  const labelOptions = [{
    value: '',
    text: strings.getSelectSeriesOption()
  }];
  labels.sort().forEach(val => labelOptions.push({
    value: val,
    text: val
  }));
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, name !== 'defaultStyle' && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getSeriesIdentifierLabel(),
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: selectedSeries,
    options: labelOptions,
    onChange: ev => handleChange('label', ev),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })), hasPropFields && /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, fields.includes('lines') && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getLineLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: (0, _lodash.get)(chainArgs, 'lines.0', 0),
    options: values,
    compressed: true,
    onChange: ev => handleChange('lines', ev),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 19
    }
  }))), fields.includes('bars') && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getBarLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: (0, _lodash.get)(chainArgs, 'bars.0', 0),
    options: values,
    compressed: true,
    onChange: ev => handleChange('bars', ev),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 19
    }
  }))), fields.includes('points') && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getPointLabel(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    value: (0, _lodash.get)(chainArgs, 'points.0', 0),
    options: values,
    compressed: true,
    onChange: ev => handleChange('points', ev),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  }))))));
};
exports.ExtendedTemplate = ExtendedTemplate;
ExtendedTemplate.displayName = 'SeriesStyleArgAdvancedInput';
ExtendedTemplate.propTypes = {
  onValueChange: _propTypes.default.func.isRequired,
  argValue: _propTypes.default.any.isRequired,
  // @ts-expect-error upgrade typescript v5.9.3
  typeInstance: _propTypes.default.object,
  resolved: _propTypes.default.shape({
    labels: _propTypes.default.array.isRequired
  }).isRequired
};