"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataViews = exports.getDataViewFields = void 0;
var _kibana_services = require("../services/kibana_services");
var _canvas_notify_service = require("../services/canvas_notify_service");
var _i18n = require("../../i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDataViews = async () => {
  try {
    return await _kibana_services.dataViewsService.getIdsWithTitle();
  } catch (e) {
    const {
      esService: strings
    } = _i18n.ErrorStrings;
    (0, _canvas_notify_service.getCanvasNotifyService)().error(e, {
      title: strings.getIndicesFetchErrorMessage()
    });
  }
  return [];
};
exports.getDataViews = getDataViews;
const getDataViewFields = async dataViewTitle => {
  const dataView = await _kibana_services.dataViewsService.create({
    title: dataViewTitle
  });
  return dataView.fields.filter(field => !field.name.startsWith('_')).map(field => field.name);
};
exports.getDataViewFields = getDataViewFields;