"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setValues = exports.setValueActionType = exports.setValue = exports.setLoadingActionType = exports.setLoading = exports.inFlightCompleteActionType = exports.inFlightComplete = exports.inFlightActiveActionType = exports.inFlightActive = exports.clearValues = exports.clearValue = void 0;
var _reduxActions = require("redux-actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setLoadingActionType = exports.setLoadingActionType = 'setResolvedLoading';
const setValueActionType = exports.setValueActionType = 'setResolvedValue';
const inFlightActiveActionType = exports.inFlightActiveActionType = 'inFlightActive';
const inFlightCompleteActionType = exports.inFlightCompleteActionType = 'inFlightComplete';
const setLoading = exports.setLoading = (0, _reduxActions.createAction)(setLoadingActionType);
const setValue = exports.setValue = (0, _reduxActions.createAction)(setValueActionType);
const setValues = exports.setValues = (0, _reduxActions.createAction)('setResolvedValues');
const clearValue = exports.clearValue = (0, _reduxActions.createAction)('clearResolvedValue');
const clearValues = exports.clearValues = (0, _reduxActions.createAction)('clearResolvedValues');
const inFlightActive = exports.inFlightActive = (0, _reduxActions.createAction)(inFlightActiveActionType, () => undefined);
const inFlightComplete = exports.inFlightComplete = (0, _reduxActions.createAction)(inFlightCompleteActionType, () => undefined);