"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workpadUpdate = void 0;
var _pages = require("../actions/pages");
var _elements = require("../actions/elements");
var _workpad = require("../actions/workpad");
var _workpad2 = require("../selectors/workpad");
var _get_window = require("../../lib/get_window");
var _doc_title = require("../../lib/doc_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const workpadUpdate = ({
  dispatch,
  getState
}) => next => action => {
  const oldIsWriteable = (0, _workpad2.isWriteable)(getState());
  const oldName = (0, _workpad2.getWorkpadName)(getState());
  next(action);

  // This middleware updates the page title when the workpad name changes
  if ((0, _workpad2.getWorkpadName)(getState()) !== oldName) {
    (0, _doc_title.setDocTitle)((0, _workpad2.getWorkpadName)(getState()));
  }

  // This middleware fetches all of the renderable elements on new, duplicate page
  if (action.type === _pages.duplicatePage.toString()) {
    dispatch((0, _elements.fetchAllRenderables)());
  }

  // This middleware clears any page selection when the writeable mode changes
  if (action.type === _workpad.setWriteable.toString() && oldIsWriteable !== (0, _workpad2.isWriteable)(getState())) {
    const win = (0, _get_window.getWindow)();

    // check for browser feature before using it
    if (typeof win.getSelection === 'function') {
      win.getSelection().collapse(document.querySelector('body'), 0);
    }
  }
};
exports.workpadUpdate = workpadUpdate;