"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.throwErrors = exports.jsonValueRt = exports.jsonScalarRt = exports.jsonObjectRt = exports.jsonArrayRt = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _format_errors = require("@kbn/securitysolution-io-ts-utils/src/format_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const throwErrors = createError => errors => {
  throw createError((0, _format_errors.formatErrors)(errors).join());
};
exports.throwErrors = throwErrors;
const jsonScalarRt = exports.jsonScalarRt = rt.union([rt.null, rt.boolean, rt.number, rt.string]);
const jsonValueRt = exports.jsonValueRt = rt.recursion('JsonValue', () => rt.union([jsonScalarRt, jsonArrayRt, jsonObjectRt]));
const jsonArrayRt = exports.jsonArrayRt = rt.recursion('JsonArray', () => rt.array(jsonValueRt));
const jsonObjectRt = exports.jsonObjectRt = rt.recursion('JsonObject', () => rt.record(rt.string, jsonValueRt));