"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttachmentsTabClickedEBT = exports.useAttachmentsSubTabClickedEBT = void 0;
var _react = require("react");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
var _use_cases_context = require("../components/cases_context/use_cases_context");
var _files = require("../files");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Events Based Tracking for Case View attachments tab
 */
const useAttachmentsTabClickedEBT = () => {
  const {
    analytics
  } = (0, _kibana.useKibana)().services;
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  return (0, _react.useCallback)(() => {
    analytics.reportEvent(_constants.CASE_VIEW_ATTACHMENTS_TAB_CLICKED_EVENT_TYPE, {
      owner: owner[0] && (0, _files.isRegisteredOwner)(owner[0]) ? owner[0] : 'unknown'
    });
  }, [analytics, owner]);
};

/**
 * Events Based Tracking for Case View attachments sub tab
 */
exports.useAttachmentsTabClickedEBT = useAttachmentsTabClickedEBT;
const useAttachmentsSubTabClickedEBT = () => {
  const {
    analytics
  } = (0, _kibana.useKibana)().services;
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  return (0, _react.useCallback)(attachmentType => {
    analytics.reportEvent(_constants.CASE_VIEW_ATTACHMENTS_SUB_TAB_CLICKED_EVENT_TYPE, {
      owner: owner[0] && (0, _files.isRegisteredOwner)(owner[0]) ? owner[0] : 'unknown',
      attachment_type: attachmentType
    });
  }, [analytics, owner]);
};
exports.useAttachmentsSubTabClickedEBT = useAttachmentsSubTabClickedEBT;