"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderWithTestingProviders = exports.mockedTestProvidersOwner = exports.createTestQueryClient = exports.TestProviders = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@testing-library/react");
var _sharedUxFileMocks = require("@kbn/shared-ux-file-mocks");
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _mocks = require("@kbn/core/public/mocks");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _cases_context = require("../../components/cases_context");
var _kibana_react = require("../lib/kibana/kibana_react.mock");
var _external_reference_registry = require("../../client/attachment_framework/external_reference_registry");
var _persistable_state_registry = require("../../client/attachment_framework/persistable_state_registry");
var _permissions = require("./permissions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/common/mock/test_providers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable no-console */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
jest.spyOn(window, 'scrollTo').mockImplementation(() => {});
const getMockedFilesClient = () => {
  const mockedFilesClient = (0, _sharedUxFileMocks.createMockFilesClient)();
  mockedFilesClient.getFileKind.mockImplementation(() => ({
    id: 'test',
    maxSizeBytes: 10000,
    http: {}
  }));
  return mockedFilesClient;
};
const mockedTestProvidersOwner = exports.mockedTestProvidersOwner = [_constants.SECURITY_SOLUTION_OWNER];
const createTestQueryClient = () => new _reactQuery.QueryClient({
  defaultOptions: {
    queries: {
      retry: false
    }
  },
  logger: {
    log: console.log,
    warn: console.warn,
    error: () => {}
  }
});

/** A utility for wrapping children in the providers required to run most tests */
exports.createTestQueryClient = createTestQueryClient;
const TestProvidersComponent = ({
  children,
  features,
  owner,
  permissions,
  releasePhase,
  externalReferenceAttachmentTypeRegistry,
  persistableStateAttachmentTypeRegistry,
  license,
  coreStart,
  services,
  queryClient,
  filesClient
}) => {
  const finalCoreStart = (0, _react.useMemo)(() => {
    return coreStart !== null && coreStart !== void 0 ? coreStart : _mocks.coreMock.createStart();
  }, [coreStart]);
  const finalServices = (0, _react.useMemo)(() => {
    return {
      ...(0, _kibana_react.createStartServicesMock)({
        license
      }),
      ...coreStart,
      ...services
    };
  }, [coreStart, license, services]);
  const defaultQueryClient = (0, _react.useMemo)(() => createTestQueryClient(), []);
  const finalQueryClient = (0, _react.useMemo)(() => queryClient !== null && queryClient !== void 0 ? queryClient : defaultQueryClient, [defaultQueryClient, queryClient]);
  const defaultPermissions = (0, _react.useMemo)(() => (0, _permissions.allCasesPermissions)(), []);
  const finalFilesClient = (0, _react.useMemo)(() => filesClient !== null && filesClient !== void 0 ? filesClient : getMockedFilesClient(), [filesClient]);
  const getFilesClientFinal = (0, _react.useCallback)(() => finalFilesClient, [finalFilesClient]);
  const defaultExternalReferenceAttachmentTypeRegistry = (0, _react.useMemo)(() => new _external_reference_registry.ExternalReferenceAttachmentTypeRegistry(), []);
  const defaultPersistableStateAttachmentTypeRegistry = (0, _react.useMemo)(() => new _persistable_state_registry.PersistableStateAttachmentTypeRegistry(), []);
  const casesProviderValue = (0, _react.useMemo)(() => ({
    externalReferenceAttachmentTypeRegistry: externalReferenceAttachmentTypeRegistry !== null && externalReferenceAttachmentTypeRegistry !== void 0 ? externalReferenceAttachmentTypeRegistry : defaultExternalReferenceAttachmentTypeRegistry,
    persistableStateAttachmentTypeRegistry: persistableStateAttachmentTypeRegistry !== null && persistableStateAttachmentTypeRegistry !== void 0 ? persistableStateAttachmentTypeRegistry : defaultPersistableStateAttachmentTypeRegistry,
    features,
    owner: owner !== null && owner !== void 0 ? owner : mockedTestProvidersOwner,
    permissions: permissions !== null && permissions !== void 0 ? permissions : defaultPermissions,
    releasePhase: releasePhase !== null && releasePhase !== void 0 ? releasePhase : 'ga',
    getFilesClient: getFilesClientFinal
  }), [defaultExternalReferenceAttachmentTypeRegistry, defaultPermissions, defaultPersistableStateAttachmentTypeRegistry, externalReferenceAttachmentTypeRegistry, features, getFilesClientFinal, owner, permissions, persistableStateAttachmentTypeRegistry, releasePhase]);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, finalCoreStart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: finalServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.MemoryRouter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_cases_context.CasesProvider, {
    value: casesProviderValue,
    queryClient: finalQueryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxFileContext.FilesContext, {
    client: finalFilesClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }, children))))));
};
TestProvidersComponent.displayName = 'TestProviders';
const TestProviders = exports.TestProviders = TestProvidersComponent;
const renderWithTestingProviders = (ui, options) => {
  const {
    wrapperProps,
    ...renderOptions
  } = options !== null && options !== void 0 ? options : {};
  return (0, _react2.render)(ui, {
    wrapper: props => /*#__PURE__*/_react.default.createElement(TestProviders, (0, _extends2.default)({}, props, wrapperProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 25
      }
    })),
    ...renderOptions
  });
};
exports.renderWithTestingProviders = renderWithTestingProviders;