"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditTagsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_get_tags = require("../../../containers/use_get_tags");
var _edit_tags_selectable = require("./edit_tags_selectable");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_focus_button = require("../../use_focus_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/actions/tags/edit_tags_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FlyoutBodyCss = (0, _react2.css)`
  ${(0, _eui.euiFullHeight)()}

  .euiFlyoutBody__overflowContent {
    ${(0, _eui.euiFullHeight)()}
  }
`;
const EditTagsFlyoutComponent = ({
  selectedCases,
  onClose,
  onSaveTags,
  focusButtonRef
}) => {
  const {
    data: tags,
    isLoading
  } = (0, _use_get_tags.useGetTags)();
  const [tagsSelection, setTagsSelection] = (0, _react.useState)({
    selectedItems: [],
    unSelectedItems: []
  });
  const onSave = (0, _react.useCallback)(() => onSaveTags(tagsSelection), [onSaveTags, tagsSelection]);
  const focusTrapProps = (0, _use_focus_button.useFocusButtonTrap)(focusButtonRef);
  const headerSubtitle = selectedCases.length > 1 ? i18n.SELECTED_CASES(selectedCases.length) : selectedCases[0].title;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": "cases-edit-tags-flyout",
    "data-test-subj": "cases-edit-tags-flyout",
    size: "s",
    paddingSize: "m",
    focusTrapProps: focusTrapProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    "data-test-subj": "cases-edit-tags-flyout-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, i18n.EDIT_TAGS)), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, headerSubtitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: FlyoutBodyCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_edit_tags_selectable.EditTagsSelectable, {
    selectedCases: selectedCases,
    isLoading: isLoading,
    tags: tags !== null && tags !== void 0 ? tags : [],
    onChangeTags: setTagsSelection,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "cases-edit-tags-flyout-cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, i18n.CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    "data-test-subj": "cases-edit-tags-flyout-submit",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, i18n.SAVE_SELECTION)))));
};
EditTagsFlyoutComponent.displayName = 'EditTagsFlyout';
const EditTagsFlyout = exports.EditTagsFlyout = /*#__PURE__*/_react.default.memo(EditTagsFlyoutComponent);