"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToMultiSelectOption = exports.MultiSelectFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/multi_select_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mapToMultiSelectOption = options => {
  return options.map(option => {
    return {
      key: option,
      label: option
    };
  });
};
exports.mapToMultiSelectOption = mapToMultiSelectOption;
const fromRawOptionsToEuiSelectableOptions = (options, selectedOptionKeys) => {
  return options.map(({
    key,
    label
  }) => {
    const selectableOption = {
      label,
      key
    };
    if (selectedOptionKeys.includes(key)) {
      selectableOption.checked = 'on';
    }
    selectableOption['data-test-subj'] = `options-filter-popover-item-${key.split(' ').join('-')}`;
    return selectableOption;
  });
};
const fromEuiSelectableOptionToRawOption = options => {
  return options.map(option => option.key);
};
const getEuiSelectableCheckedOptions = options => options.filter(option => option.checked === 'on');
const MultiSelectFilter = ({
  buttonLabel,
  buttonIconType,
  hideActiveOptionsNumber,
  id,
  limit,
  limitReachedMessage,
  onChange,
  options: rawOptions,
  selectedOptionKeys = [],
  renderOption,
  isLoading,
  buttonCss
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const toggleIsPopoverOpen = () => setIsPopoverOpen(prevValue => !prevValue);
  const showActiveOptionsNumber = !hideActiveOptionsNumber;
  const isInvalid = Boolean(limit && limitReachedMessage && selectedOptionKeys.length >= limit);
  const options = fromRawOptionsToEuiSelectableOptions(rawOptions, selectedOptionKeys);
  (0, _react.useEffect)(() => {
    const newSelectedOptions = selectedOptionKeys.filter(selectedOptionKey => rawOptions.some(({
      key: optionKey
    }) => optionKey === selectedOptionKey));
    if (!(0, _fp.isEqual)(newSelectedOptions, selectedOptionKeys) && !isLoading) {
      onChange({
        filterId: id,
        selectedOptionKeys: newSelectedOptions
      });
    }
  }, [selectedOptionKeys, rawOptions, id, onChange, isLoading]);
  const _onChange = newOptions => {
    const newSelectedOptions = getEuiSelectableCheckedOptions(newOptions);
    if (isInvalid && limit && newSelectedOptions.length >= limit) {
      return;
    }
    onChange({
      filterId: id,
      selectedOptionKeys: fromEuiSelectableOptionToRawOption(newSelectedOptions)
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      css: (0, _react2.css)`
            max-width: 186px;
            ${buttonCss}
          `,
      "data-test-subj": `options-filter-popover-button-${id}`,
      iconType: buttonIconType || 'arrowDown',
      onClick: toggleIsPopoverOpen,
      isSelected: isPopoverOpen,
      numFilters: showActiveOptionsNumber ? options.length : undefined,
      hasActiveFilters: showActiveOptionsNumber ? selectedOptionKeys.length > 0 : undefined,
      numActiveFilters: showActiveOptionsNumber ? selectedOptionKeys.length : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textTruncate",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }, buttonLabel)),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none",
    repositionOnScroll: true,
    panelProps: {
      'data-test-subj': `options-filter-popover-panel-${id}`
    },
    "data-test-subj": `options-filter-popover-${id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, isInvalid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: limitReachedMessage,
    color: "warning",
    size: "s",
    "data-test-subj": "maximum-length-warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: options,
    searchable: true,
    searchProps: {
      placeholder: buttonLabel,
      compressed: false,
      'data-test-subj': `${id}-search-input`
    },
    emptyMessage: i18n.EMPTY_FILTER_MESSAGE,
    onChange: _onChange,
    singleSelection: false,
    renderOption: renderOption,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              width: 400px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, search), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                line-height: ${euiTheme.size.xl};
                padding-left: ${euiTheme.size.m};
                border-bottom: ${euiTheme.border.thin};
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }, i18n.OPTIONS(options.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }), list)));
};
exports.MultiSelectFilter = MultiSelectFilter;
MultiSelectFilter.displayName = 'MultiSelectFilter';