"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseViewAttachments = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_attachments_tab_ebt = require("../../../analytics/use_attachments_tab_ebt");
var _navigation = require("../../../common/navigation");
var _types = require("../../../../common/types");
var _case_view_tabs = require("../case_view_tabs");
var _use_case_attachment_tabs = require("../use_case_attachment_tabs");
var _translations = require("../translations");
var _translations2 = require("../../actions/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/case_view_attachments.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const translateTitle = activeTab => {
  switch (activeTab) {
    case _types.CASE_VIEW_PAGE_TABS.ALERTS:
      {
        return _translations.ALERTS_TAB;
      }
    case _types.CASE_VIEW_PAGE_TABS.EVENTS:
      {
        return _translations.EVENTS_TAB;
      }
    case _types.CASE_VIEW_PAGE_TABS.FILES:
      {
        return _translations.FILES_TAB;
      }
    case _types.CASE_VIEW_PAGE_TABS.OBSERVABLES:
      {
        return _translations.OBSERVABLES_TAB;
      }

    // NOTE:this should not be called
    default:
      return _translations.ATTACHMENTS_TAB;
  }
};
const CaseViewAttachments = ({
  caseData,
  activeTab,
  onSearch,
  searchTerm,
  children
}) => {
  const {
    tabs: caseViewTabs
  } = (0, _use_case_attachment_tabs.useCaseAttachmentTabs)({
    caseData,
    activeTab,
    searchTerm
  });
  const {
    navigateToCaseView
  } = (0, _navigation.useCaseViewNavigation)();
  const trackSubTabClick = (0, _use_attachments_tab_ebt.useAttachmentsSubTabClickedEBT)();
  const tabAsSelectableOptions = (0, _react.useMemo)(() => {
    return caseViewTabs.map(tab => ({
      label: tab.name,
      'data-test-subj': `case-view-tab-title-${tab.id}`,
      append: tab.badge,
      isFocused: tab.id === activeTab,
      onFocusBadge: false,
      showIcons: false,
      onClick: () => {
        navigateToCaseView({
          detailName: caseData.id,
          tabId: tab.id
        });
        trackSubTabClick(tab.id);
      }
    }));
  }, [caseViewTabs, activeTab, navigateToCaseView, caseData.id, trackSubTabClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_case_view_tabs.CaseViewTabs, {
    caseData: caseData,
    activeTab: activeTab,
    searchTerm: searchTerm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    placeholder: _translations2.SEARCH_PLACEHOLDER,
    onSearch: onSearch,
    "data-test-subj": "cases-files-search",
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    responsive: false,
    "data-test-subj": "case-view-attachments",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    css: {
      minWidth: '18rem',
      maxWidth: '18rem'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    singleSelection: true,
    options: tabAsSelectableOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, list => list)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, translateTitle(activeTab))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }), children))));
};
exports.CaseViewAttachments = CaseViewAttachments;
CaseViewAttachments.displayName = 'CaseViewAttachments';