"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_CASE_FILES_FILTERING_OPTIONS = exports.CaseViewFiles = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_get_case_files = require("../../../containers/use_get_case_files");
var _files_table = require("../../files/files_table");
var _files_utility_bar = require("../../files/files_utility_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/case_view/components/case_view_files.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_CASE_FILES_FILTERING_OPTIONS = exports.DEFAULT_CASE_FILES_FILTERING_OPTIONS = {
  page: 0,
  perPage: 10
};
const CaseViewFiles = ({
  caseData,
  searchTerm
}) => {
  var _caseFiles$files;
  const searchTermRef = (0, _react.useRef)(searchTerm);
  const [filteringOptions, setFilteringOptions] = (0, _react.useState)({
    ...DEFAULT_CASE_FILES_FILTERING_OPTIONS,
    ...(searchTerm && {
      searchTerm
    })
  });
  (0, _react.useEffect)(() => {
    if (searchTermRef.current !== searchTerm) {
      searchTermRef.current = searchTerm;
      setFilteringOptions(prev => ({
        // reset pagination when search term changes
        page: 0,
        perPage: prev.perPage,
        ...(searchTerm && {
          searchTerm
        })
      }));
    }
  }, [searchTerm, setFilteringOptions]);
  const {
    data: caseFiles,
    isLoading,
    isPreviousData
  } = (0, _use_get_case_files.useGetCaseFiles)({
    ...filteringOptions,
    caseId: caseData.id
  });
  const onTableChange = (0, _react.useCallback)(({
    page
  }) => {
    if (page && !isPreviousData) {
      setFilteringOptions({
        ...filteringOptions,
        page: page.index,
        perPage: page.size
      });
    }
  }, [filteringOptions, isPreviousData]);
  const pagination = (0, _react.useMemo)(() => {
    var _caseFiles$total;
    return {
      pageIndex: filteringOptions.page,
      pageSize: filteringOptions.perPage,
      totalItemCount: (_caseFiles$total = caseFiles === null || caseFiles === void 0 ? void 0 : caseFiles.total) !== null && _caseFiles$total !== void 0 ? _caseFiles$total : 0,
      pageSizeOptions: [10, 25, 50],
      showPerPageOptions: true
    };
  }, [filteringOptions.page, filteringOptions.perPage, caseFiles === null || caseFiles === void 0 ? void 0 : caseFiles.total]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_files_utility_bar.FilesUtilityBar, {
    caseId: caseData.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_files_table.FilesTable, {
    caseId: caseData.id,
    isLoading: isLoading,
    items: (_caseFiles$files = caseFiles === null || caseFiles === void 0 ? void 0 : caseFiles.files) !== null && _caseFiles$files !== void 0 ? _caseFiles$files : [],
    onChange: onTableChange,
    pagination: pagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  })));
};
exports.CaseViewFiles = CaseViewFiles;
CaseViewFiles.displayName = 'CaseViewFiles';