"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCaseObservables = void 0;
var _react = require("react");
var _constants = require("../../../common/constants");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCaseObservables = (caseData, searchTerm) => {
  const {
    data: currentConfiguration,
    isLoading: loadingCaseConfigure
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  return (0, _react.useMemo)(() => {
    if (loadingCaseConfigure) {
      return {
        observables: [],
        isLoading: true
      };
    }
    const availableTypesSet = new Set([..._constants.OBSERVABLE_TYPES_BUILTIN_KEYS, ...currentConfiguration.observableTypes.map(({
      key
    }) => key)]);
    return {
      observables: caseData.observables.filter(({
        typeKey,
        value
      }) => availableTypesSet.has(typeKey) && (!searchTerm || value.toLowerCase().includes(searchTerm.toLowerCase()))),
      isLoading: loadingCaseConfigure
    };
  }, [caseData.observables, currentConfiguration.observableTypes, loadingCaseConfigure, searchTerm]);
};
exports.useCaseObservables = useCaseObservables;