"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../common/lib/kibana");
var _use_get_choices = require("./use_get_choices");
var _helpers = require("./helpers");
var _deprecated_callout = require("../deprecated_callout");
var _validate_json = require("../validate_json");
var _json_editor_field = require("../json_editor_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/servicenow/servicenow_itsm_case_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const choicesToGet = ['urgency', 'severity', 'impact', 'category', 'subcategory'];
const defaultFields = {
  urgency: [],
  severity: [],
  impact: [],
  category: [],
  subcategory: []
};
const validateJSON = (0, _validate_json.generateJSONValidator)();
const ServiceNowITSMFieldsComponent = ({
  connector
}) => {
  var _choicesData$data;
  const form = (0, _hook_form_lib.useFormContext)();
  const [{
    fields
  }] = (0, _hook_form_lib.useFormData)();
  const {
    category = null
  } = fields !== null && fields !== void 0 ? fields : {};
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const showConnectorWarning = connector.isDeprecated;
  const {
    isLoading,
    isFetching,
    data: choicesData
  } = (0, _use_get_choices.useGetChoices)({
    http,
    connector,
    fields: choicesToGet
  });
  const choices = (_choicesData$data = choicesData === null || choicesData === void 0 ? void 0 : choicesData.data) !== null && _choicesData$data !== void 0 ? _choicesData$data : [];
  const isLoadingChoices = isLoading || isFetching;
  const choicesFormatted = choices.reduce((acc, value) => ({
    ...acc,
    [value.element]: [...(acc[value.element] != null ? acc[value.element] : []), value]
  }), defaultFields);
  const categoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.category), [choicesFormatted.category]);
  const urgencyOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.urgency), [choicesFormatted.urgency]);
  const severityOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.severity), [choicesFormatted.severity]);
  const impactOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.impact), [choicesFormatted.impact]);
  const subcategoryOptions = (0, _react.useMemo)(() => (0, _helpers.choicesToEuiOptions)(choicesFormatted.subcategory.filter(choice => choice.dependent_value === category)), [choicesFormatted.subcategory, category]);
  const onCategoryChange = () => {
    form.setFieldValue('fields.subcategory', null);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConnectorWarning && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "connector-fields-sn-itsm",
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.urgency",
    component: _components.SelectField,
    config: {
      label: i18n.URGENCY
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'urgencySelect',
        options: urgencyOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.severity",
    component: _components.SelectField,
    config: {
      label: i18n.SEVERITY
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'severitySelect',
        options: severityOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.impact",
    component: _components.SelectField,
    config: {
      label: i18n.IMPACT
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'impactSelect',
        options: impactOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.category",
    component: _components.SelectField,
    config: {
      label: i18n.CATEGORY
    },
    onChange: onCategoryChange,
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'categorySelect',
        options: categoryOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.subcategory",
    component: _components.SelectField,
    config: {
      label: i18n.SUBCATEGORY
    },
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'subcategorySelect',
        options: subcategoryOptions,
        hasNoInitialSelection: true,
        fullWidth: true,
        disabled: isLoadingChoices,
        isLoading: isLoadingChoices
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "fields.additionalFields",
    component: _json_editor_field.JsonEditorField,
    config: {
      label: i18n.ADDITIONAL_FIELDS_LABEL,
      validations: [{
        validator: validateJSON
      }]
    },
    componentProps: {
      euiCodeEditorProps: {
        fullWidth: true,
        height: '200px',
        options: {
          fontSize: '12px',
          renderValidationDecorations: 'off'
        }
      },
      dataTestSubj: 'additionalFieldsEditor'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 13
    }
  })))));
};
exports.default = ServiceNowITSMFieldsComponent;
ServiceNowITSMFieldsComponent.displayName = 'ServiceNowITSMFields';
// eslint-disable-next-line import/no-default-export
module.exports = exports.default;