"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUploadStart = useUploadStart;
var _react = require("react");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUploadStart(state, dispatch, textarea, field) {
  // Handle uploading state
  (0, _react.useEffect)(() => {
    const {
      phase
    } = state;
    if (phase !== _types.UploadPhase.START_UPLOAD || !textarea) return;
    const {
      filename,
      placeholder
    } = state;
    const {
      selectionStart,
      selectionEnd
    } = textarea;
    const before = field.value.slice(0, selectionStart);
    const after = field.value.slice(selectionEnd);
    field.setValue(before + placeholder + after);
    dispatch({
      type: _types.ActionType.UPLOAD_IN_PROGRESS,
      filename,
      placeholder
    });
  }, [state, textarea, field, dispatch]);
}