"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/observable_types/delete_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteConfirmationModalComponent = ({
  label,
  onCancel,
  onConfirm
}) => {
  const titleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    buttonColor: "danger",
    cancelButtonText: i18n.CANCEL,
    "data-test-subj": "confirm-delete-observable-modal",
    defaultFocusedButton: "confirm",
    onCancel: onCancel,
    onConfirm: onConfirm,
    title: i18n.DELETE_OBSERVABLE_TYPE_TITLE(label),
    titleProps: {
      id: titleId
    },
    confirmButtonText: i18n.DELETE,
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, i18n.DELETE_OBSERVABLE_TYPE_DESCRIPTION);
};
DeleteConfirmationModalComponent.displayName = 'DeleteConfirmationModal';
const DeleteConfirmationModal = exports.DeleteConfirmationModal = /*#__PURE__*/_react.default.memo(DeleteConfirmationModalComponent);