"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.normalizeValueType = exports.fieldsConfig = void 0;
var _helpers = require("@kbn/es-ui-shared-plugin/static/forms/helpers");
var _validators = require("../../../common/observables/validators");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERIC_OBSERVABLE_VALUE_TYPE = 'generic';
const normalizeValueType = observableTypeKey => {
  if (observableTypeKey in fieldsConfig.value) {
    return observableTypeKey;
  }
  return GENERIC_OBSERVABLE_VALUE_TYPE;
};
exports.normalizeValueType = normalizeValueType;
const {
  emptyField
} = _helpers.fieldValidators;
const validationsFactory = (observableTypeKey, message = i18n.INVALID_VALUE) => [{
  validator: emptyField(i18n.REQUIRED_VALUE)
}, {
  validator: (...args) => {
    const [{
      value,
      path
    }] = args;
    const validationResult = (0, _validators.getValidatorForObservableType)(observableTypeKey)(value);
    if (validationResult) {
      return {
        ...validationResult,
        message,
        path
      };
    }
  }
}];
const observableValueFieldTypes = [{
  key: undefined,
  label: i18n.FIELD_LABEL_VALUE
}, {
  key: _constants.OBSERVABLE_TYPE_EMAIL.key,
  label: 'Email'
}, {
  key: _constants.OBSERVABLE_TYPE_DOMAIN.key,
  label: 'Domain'
}, {
  key: _constants.OBSERVABLE_TYPE_IPV4.key,
  label: 'IPv4'
}, {
  key: _constants.OBSERVABLE_TYPE_IPV6.key,
  label: 'IPv6'
}, {
  key: _constants.OBSERVABLE_TYPE_URL.key,
  label: 'URL'
}];
const fieldsValueConfigsPerObservableType = observableValueFieldTypes.reduce((fieldsConfig, valueFieldConfig) => {
  var _valueFieldConfig$key;
  fieldsConfig[(_valueFieldConfig$key = valueFieldConfig.key) !== null && _valueFieldConfig$key !== void 0 ? _valueFieldConfig$key : GENERIC_OBSERVABLE_VALUE_TYPE] = {
    label: valueFieldConfig.label,
    validations: validationsFactory(valueFieldConfig.key)
  };
  return fieldsConfig;
}, {});
const fieldsConfig = exports.fieldsConfig = {
  value: fieldsValueConfigsPerObservableType,
  typeKey: {
    validations: [{
      validator: emptyField(i18n.REQUIRED_VALUE)
    }],
    label: i18n.FIELD_LABEL_TYPE
  },
  description: {
    label: i18n.FIELD_LABEL_DESCRIPTION
  }
};