"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservablesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../common/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_observable = require("./add_observable");
var _observable_actions_popover_button = require("./observable_actions_popover_button");
var _use_get_case_configuration = require("../../containers/configure/use_get_case_configuration");
var _observables_utility_bar = require("./observables_utility_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1769677912408185922/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/cases/public/components/observables/observables_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getColumns = (caseData, observableTypes) => [{
  name: i18n.OBSERVABLE_VALUE,
  field: 'value',
  'data-test-subj': 'cases-observables-table-value'
}, {
  name: i18n.OBSERVABLE_TYPE,
  field: 'typeKey',
  'data-test-subj': 'cases-observables-table-type',
  render: typeKey => {
    var _observableTypes$find;
    return ((_observableTypes$find = observableTypes.find(observableType => observableType.key === typeKey)) === null || _observableTypes$find === void 0 ? void 0 : _observableTypes$find.label) || '-';
  }
}, {
  name: i18n.OBSERVABLE_DESCRIPTION,
  field: 'description',
  'data-test-subj': 'cases-observables-table-description'
}, {
  name: i18n.DATE_ADDED,
  field: 'createdAt',
  'data-test-subj': 'cases-observables-table-date-added',
  dataType: 'date'
}, {
  name: i18n.OBSERVABLE_ACTIONS,
  field: 'actions',
  'data-test-subj': 'cases-observables-table-actions',
  width: '120px',
  actions: [{
    name: i18n.OBSERVABLE_ACTIONS,
    render: observable => {
      return /*#__PURE__*/_react.default.createElement(_observable_actions_popover_button.ObservableActionsPopoverButton, {
        caseData: caseData,
        observable: observable,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 18
        }
      });
    }
  }]
}];
const EmptyObservablesTable = ({
  caseData
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 12
    }
  }, i18n.NO_OBSERVABLES),
  "data-test-subj": "cases-observables-table-empty",
  titleSize: "xs",
  actions: /*#__PURE__*/_react.default.createElement(_add_observable.AddObservable, {
    caseData: caseData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 14
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 3
  }
});
EmptyObservablesTable.displayName = 'EmptyObservablesTable';
const ObservablesTable = ({
  caseData,
  isLoading,
  onExtractObservablesChanged
}) => {
  const filesTableRowProps = (0, _react.useCallback)(observable => ({
    'data-test-subj': `cases-observables-table-row-${observable.id}`
  }), []);
  const {
    data: currentConfiguration,
    isLoading: loadingCaseConfigure
  } = (0, _use_get_case_configuration.useGetCaseConfiguration)();
  const observableTypes = (0, _react.useMemo)(() => [..._constants.OBSERVABLE_TYPES_BUILTIN, ...currentConfiguration.observableTypes], [currentConfiguration.observableTypes]);
  const columns = (0, _react.useMemo)(() => getColumns(caseData, observableTypes), [caseData, observableTypes]);
  return isLoading || loadingCaseConfigure ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "cases-observables-table-loading",
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_observables_utility_bar.ObservablesUtilityBar, {
    caseData: caseData,
    isLoading: isLoading,
    onExtractObservablesChanged: onExtractObservablesChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    tableCaption: i18n.OBSERVABLES_TABLE,
    items: caseData.observables,
    rowHeader: "id",
    columns: columns,
    "data-test-subj": "cases-observables-table",
    noItemsMessage: /*#__PURE__*/_react.default.createElement(EmptyObservablesTable, {
      caseData: caseData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 25
      }
    }),
    rowProps: filesTableRowProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }));
};
exports.ObservablesTable = ObservablesTable;
ObservablesTable.displayName = 'ObservablesTable';