"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WEEKS = exports.TIME_WINDOW_WARNING = exports.TIME_WINDOW_VALUE_LABEL = exports.TIME_WINDOW_UNIT_LABEL = exports.TIME_WINDOW_SIZE_ERROR = exports.TIME_WINDOW = exports.REOPEN_WHEN_CASE_IS_CLOSED = exports.MIN_TIME_WINDOW_SIZE_ERROR = exports.MINUTES = exports.HOURS = exports.GROUP_BY_ALERT_OPTIONAL_LABEL = exports.GROUP_BY_ALERT = exports.DEFAULT_EMPTY_TEMPLATE_NAME = exports.DAYS = exports.CASE_ACTION_DESC = exports.ATTACK_DISCOVERY_TEMPLATE_TOOLTIP = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CASE_ACTION_DESC = exports.CASE_ACTION_DESC = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.selectMessageText', {
  defaultMessage: 'Create a case in Kibana.'
});
const GROUP_BY_ALERT = exports.GROUP_BY_ALERT = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.groupByLabel', {
  defaultMessage: 'Group by alert field'
});
const TIME_WINDOW = exports.TIME_WINDOW = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.timeWindowLabel', {
  defaultMessage: 'Time window'
});
const TIME_WINDOW_VALUE_LABEL = exports.TIME_WINDOW_VALUE_LABEL = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.timeWindowValueLabel', {
  defaultMessage: 'Time window value'
});
const TIME_WINDOW_UNIT_LABEL = exports.TIME_WINDOW_UNIT_LABEL = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.timeWindowUnitLabel', {
  defaultMessage: 'Time window unit'
});
const TIME_WINDOW_SIZE_ERROR = exports.TIME_WINDOW_SIZE_ERROR = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.timeWindowSizeError', {
  defaultMessage: 'Invalid time window.'
});
const MIN_TIME_WINDOW_SIZE_ERROR = exports.MIN_TIME_WINDOW_SIZE_ERROR = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.minTimeWindowSizeError', {
  defaultMessage: 'Time window should be at least 5 minutes'
});
const REOPEN_WHEN_CASE_IS_CLOSED = exports.REOPEN_WHEN_CASE_IS_CLOSED = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.reopenWhenCaseIsClosed', {
  defaultMessage: 'Reopen when the case is closed'
});
const DAYS = timeValue => _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.daysLabel', {
  defaultMessage: '{timeValue, plural, one {day} other {days}}',
  values: {
    timeValue
  }
});
exports.DAYS = DAYS;
const WEEKS = timeValue => _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.weeksLabel', {
  defaultMessage: '{timeValue, plural, one {week} other {weeks}}',
  values: {
    timeValue
  }
});
exports.WEEKS = WEEKS;
const HOURS = timeValue => _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.hoursLabel', {
  defaultMessage: '{timeValue, plural, one {hour} other {hours}}',
  values: {
    timeValue
  }
});
exports.HOURS = HOURS;
const MINUTES = timeValue => _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.minutesLabel', {
  defaultMessage: '{timeValue, plural, one {minute} other {minutes}}',
  values: {
    timeValue
  }
});
exports.MINUTES = MINUTES;
const DEFAULT_EMPTY_TEMPLATE_NAME = exports.DEFAULT_EMPTY_TEMPLATE_NAME = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.defaultEmptyTemplateName', {
  defaultMessage: 'No template selected'
});
const GROUP_BY_ALERT_OPTIONAL_LABEL = exports.GROUP_BY_ALERT_OPTIONAL_LABEL = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.groupByAlertOptionalField', {
  defaultMessage: 'Optional'
});
const TIME_WINDOW_WARNING = exports.TIME_WINDOW_WARNING = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.timeWindowWarning', {
  defaultMessage: 'Setting a time window of 20 minutes or less may increase the number of cases generated by this action.'
});
const ATTACK_DISCOVERY_TEMPLATE_TOOLTIP = exports.ATTACK_DISCOVERY_TEMPLATE_TOOLTIP = _i18n.i18n.translate('xpack.cases.systemActions.casesConnector.attackDiscoveryTemplateTooltip', {
  defaultMessage: 'Attack Discovery Schedules fully manage Case actions, automatically filling in all fields for new Cases.'
});