"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensCaseAttachment = void 0;
var _visualizations = require("../../../../common/constants/visualizations");
var _domain = require("../../../../common/types/domain");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLensCaseAttachment = ({
  timeRange,
  attributes,
  metadata
}) => ({
  persistableStateAttachmentState: {
    attributes,
    timeRange,
    metadata
  },
  persistableStateAttachmentTypeId: _visualizations.LENS_ATTACHMENT_TYPE,
  type: _domain.AttachmentType.persistableState
});
exports.getLensCaseAttachment = getLensCaseAttachment;