"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateTemplatesCustomFieldsInRequest = exports.validateCustomFieldTypesInRequest = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _validators = require("../validators");
var _validators2 = require("../cases/validators");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Throws an error if the request tries to change the type of existing custom fields.
 */
const validateCustomFieldTypesInRequest = ({
  requestCustomFields,
  originalCustomFields
}) => {
  if (!Array.isArray(requestCustomFields) || !originalCustomFields.length) {
    return;
  }
  const invalidFields = [];
  requestCustomFields.forEach(requestField => {
    const originalField = originalCustomFields.find(item => item.key === requestField.key);
    if (originalField && originalField.type !== requestField.type) {
      invalidFields.push(`"${requestField.label}"`);
    }
  });
  if (invalidFields.length > 0) {
    throw _boom.default.badRequest(`Invalid custom field types in request for the following labels: ${invalidFields.join(', ')}`);
  }
};
exports.validateCustomFieldTypesInRequest = validateCustomFieldTypesInRequest;
const validateTemplatesCustomFieldsInRequest = ({
  templates,
  customFieldsConfiguration
}) => {
  if (!Array.isArray(templates) || !templates.length) {
    return;
  }
  templates.forEach((template, index) => {
    var _template$caseFields, _template$caseFields$, _template$caseFields2;
    if (customFieldsConfiguration === undefined && (_template$caseFields = template.caseFields) !== null && _template$caseFields !== void 0 && (_template$caseFields$ = _template$caseFields.customFields) !== null && _template$caseFields$ !== void 0 && _template$caseFields$.length) {
      throw _boom.default.badRequest('No custom fields configured.');
    }
    if ((!template.caseFields || !template.caseFields.customFields || !template.caseFields.customFields.length) && customFieldsConfiguration !== null && customFieldsConfiguration !== void 0 && customFieldsConfiguration.length) {
      throw _boom.default.badRequest('No custom fields added to template.');
    }
    const params = {
      requestCustomFields: template === null || template === void 0 ? void 0 : (_template$caseFields2 = template.caseFields) === null || _template$caseFields2 === void 0 ? void 0 : _template$caseFields2.customFields,
      customFieldsConfiguration
    };
    (0, _validators.validateDuplicatedKeysInRequest)({
      requestFields: params.requestCustomFields,
      fieldName: `templates[${index}]'s customFields`
    });
    (0, _validators2.validateCustomFieldKeysAgainstConfiguration)(params);
    (0, _validators2.validateCustomFieldTypesInRequest)(params);
  });
};
exports.validateTemplatesCustomFieldsInRequest = validateTemplatesCustomFieldsInRequest;