"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUserRequests = exports.createPersistableStateRequests = exports.createFileRequests = exports.createExternalReferenceRequests = exports.createAlertRequests = void 0;
var _domain = require("../../../common/types/domain");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createUserRequests = num => {
  const requests = [...Array(num).keys()].map(value => {
    return {
      comment: `${value}`,
      type: _domain.AttachmentType.user,
      owner: 'test'
    };
  });
  return requests;
};
exports.createUserRequests = createUserRequests;
const createPersistableStateRequests = num => {
  return [...Array(num).keys()].map(() => {
    return {
      persistableStateAttachmentTypeId: '.test',
      persistableStateAttachmentState: {},
      type: _domain.AttachmentType.persistableState,
      owner: 'test'
    };
  });
};
exports.createPersistableStateRequests = createPersistableStateRequests;
const createExternalReferenceRequests = num => {
  return [...Array(num).keys()].map(value => {
    return {
      type: _domain.AttachmentType.externalReference,
      owner: 'test',
      externalReferenceAttachmentTypeId: '.test',
      externalReferenceId: 'so-id',
      externalReferenceMetadata: {},
      externalReferenceStorage: {
        soType: `${value}`,
        type: _domain.ExternalReferenceStorageType.savedObject
      }
    };
  });
};
exports.createExternalReferenceRequests = createExternalReferenceRequests;
const createFileRequests = ({
  numRequests,
  numFiles
}) => {
  const files = [...Array(numFiles).keys()].map(value => {
    return {
      name: `${value}`,
      created: '2023-02-27T20:26:54.345Z',
      extension: 'png',
      mimeType: 'image/png'
    };
  });
  const requests = [...Array(numRequests).keys()].map(value => {
    return {
      type: _domain.AttachmentType.externalReference,
      externalReferenceAttachmentTypeId: _constants.FILE_ATTACHMENT_TYPE,
      externalReferenceId: 'so-id',
      externalReferenceMetadata: {
        files
      },
      externalReferenceStorage: {
        soType: `${value}`,
        type: _domain.ExternalReferenceStorageType.savedObject
      },
      owner: 'test'
    };
  });
  return requests;
};
exports.createFileRequests = createFileRequests;
const createAlertRequests = (numberOfRequests, alertIds) => {
  const requests = [...Array(numberOfRequests).keys()].map(value => {
    return {
      type: _domain.AttachmentType.alert,
      alertId: alertIds,
      index: alertIds,
      rule: {
        id: null,
        name: null
      },
      owner: `${value}`
    };
  });
  return requests;
};
exports.createAlertRequests = createAlertRequests;