"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findCommentsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
var _create_cases_route = require("../create_cases_route");
var _error = require("../../../common/error");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findCommentsRoute = exports.findCommentsRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'get',
  path: _constants.CASE_FIND_ATTACHMENTS_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    params: _configSchema.schema.object({
      case_id: _configSchema.schema.string()
    })
  },
  routerOptions: {
    access: 'public',
    summary: `Find case comments and alerts`,
    tags: ['oas-tag:cases'],
    description: 'Retrieves a paginated list of comments and alerts for a case.'
    // You must have `read` privileges for the **Cases** feature in the **Management**, **Observability**, or **Security** section of the Kibana feature privileges, depending on the owner of the cases with the comments you're seeking.
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    try {
      const caseContext = await context.cases;
      const client = await caseContext.getCasesClient();
      const query = request.query;
      const res = await client.attachments.find({
        caseID: request.params.case_id,
        findQueryParams: query
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      throw (0, _error.createCaseError)({
        message: `Failed to find comments in route case id: ${request.params.case_id}: ${error}`,
        error
      });
    }
  }
});